/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auth.internal;

import com.amazon.opendistroforelasticsearch.security.auth.AuthenticationBackend;
import com.amazon.opendistroforelasticsearch.security.auth.AuthorizationBackend;
import com.amazon.opendistroforelasticsearch.security.securityconf.InternalUsersModel;
import com.amazon.opendistroforelasticsearch.security.user.AuthCredentials;
import com.amazon.opendistroforelasticsearch.security.user.User;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.ElasticsearchSecurityException;
import org.greenrobot.eventbus.Subscribe;

public class InternalAuthenticationBackend
implements AuthenticationBackend,
AuthorizationBackend {
    private InternalUsersModel internalUsersModel;

    @Override
    public boolean exists(User user) {
        if (user == null || this.internalUsersModel == null) {
            return false;
        }
        boolean exists = this.internalUsersModel.exists(user.getName());
        if (exists) {
            List<String> openDistroSecurityRoles;
            user.addRoles(this.internalUsersModel.getBackenRoles(user.getName()));
            Map<String, String> customAttributes = this.internalUsersModel.getAttributes(user.getName());
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            if (customAttributes != null) {
                for (Map.Entry<String, String> attributeEntry : customAttributes.entrySet()) {
                    attributeMap.put("attr.internal." + attributeEntry.getKey(), attributeEntry.getValue());
                }
            }
            if ((openDistroSecurityRoles = this.internalUsersModel.getOpenDistroSecurityRoles(user.getName())) != null) {
                user.addOpenDistroSecurityRoles(openDistroSecurityRoles);
            }
            user.addAttributes(attributeMap);
            return true;
        }
        return false;
    }

    @Override
    public User authenticate(AuthCredentials credentials) {
        if (this.internalUsersModel == null) {
            throw new ElasticsearchSecurityException("Internal authentication backend not configured. May be Open Distro is not initialized.", new Object[0]);
        }
        if (!this.internalUsersModel.exists(credentials.getUsername())) {
            throw new ElasticsearchSecurityException(credentials.getUsername() + " not found", new Object[0]);
        }
        byte[] password = credentials.getPassword();
        if (password == null || password.length == 0) {
            throw new ElasticsearchSecurityException("empty passwords not supported", new Object[0]);
        }
        ByteBuffer wrap = ByteBuffer.wrap(password);
        CharBuffer buf = StandardCharsets.UTF_8.decode(wrap);
        char[] array = new char[buf.limit()];
        buf.get(array);
        Arrays.fill(password, (byte)0);
        try {
            if (OpenBSDBCrypt.checkPassword((String)this.internalUsersModel.getHash(credentials.getUsername()), (char[])array)) {
                List<String> roles = this.internalUsersModel.getBackenRoles(credentials.getUsername());
                Map<String, String> customAttributes = this.internalUsersModel.getAttributes(credentials.getUsername());
                if (customAttributes != null) {
                    for (Map.Entry<String, String> attributeName : customAttributes.entrySet()) {
                        credentials.addAttribute("attr.internal." + attributeName.getKey(), attributeName.getValue());
                    }
                }
                User user = new User(credentials.getUsername(), roles, credentials);
                List<String> openDistroSecurityRoles = this.internalUsersModel.getOpenDistroSecurityRoles(credentials.getUsername());
                if (openDistroSecurityRoles != null) {
                    user.addOpenDistroSecurityRoles(openDistroSecurityRoles);
                }
                User user2 = user;
                return user2;
            }
            throw new ElasticsearchSecurityException("password does not match", new Object[0]);
        }
        finally {
            Arrays.fill(wrap.array(), (byte)0);
            Arrays.fill(buf.array(), '\u0000');
            Arrays.fill(array, '\u0000');
        }
    }

    @Override
    public String getType() {
        return "internal";
    }

    @Override
    public void fillRoles(User user, AuthCredentials credentials) throws ElasticsearchSecurityException {
        List<String> roles;
        if (this.internalUsersModel == null) {
            throw new ElasticsearchSecurityException("Internal authentication backend not configured. May be Open Distro Security is not initialized.", new Object[0]);
        }
        if (this.exists(user) && (roles = this.internalUsersModel.getBackenRoles(user.getName())) != null && !roles.isEmpty() && user != null) {
            user.addRoles(roles);
        }
    }

    @Subscribe
    public void onInternalUsersModelChanged(InternalUsersModel ium) {
        this.internalUsersModel = ium;
    }
}

