/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auth;

import com.amazon.opendistroforelasticsearch.security.user.User;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class RolesInjector {
    protected final Logger log = LogManager.getLogger(RolesInjector.class);

    public Set<String> injectUserAndRoles(ThreadContext ctx) {
        String injectedUserAndRoles = (String)ctx.getTransient("opendistro_security_injected_roles");
        if (injectedUserAndRoles == null) {
            return null;
        }
        this.log.debug("Injected roles: {}", (Object)injectedUserAndRoles);
        String[] strs = injectedUserAndRoles.split("\\|");
        if (strs.length == 0) {
            this.log.error("Roles injected string malformed, could not extract parts. User string was '{}.' Roles injection failed.", (Object)injectedUserAndRoles);
            return null;
        }
        if (StringUtils.isEmpty((String)StringUtils.trim((String)strs[0]))) {
            this.log.error("Username must be provided, injected string was '{}.' Roles injection failed.", (Object)injectedUserAndRoles);
            return null;
        }
        User user = new User(strs[0]);
        if (strs.length < 2 || StringUtils.isEmpty((String)StringUtils.trim((String)strs[0]))) {
            this.log.error("Roles must be provided, injected string was '{}.' Roles injection failed.", (Object)injectedUserAndRoles);
            return null;
        }
        ImmutableSet roles = ImmutableSet.copyOf((Object[])strs[1].split(","));
        if (user != null && roles != null) {
            this.addUser(user, ctx);
        }
        return roles;
    }

    private void addUser(User user, ThreadContext threadContext) {
        if (threadContext.getTransient("_opendistro_security_user") != null) {
            return;
        }
        threadContext.putTransient("_opendistro_security_user", (Object)user);
    }
}

