/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auth;

import com.amazon.opendistroforelasticsearch.security.auth.AuthenticationBackend;
import com.amazon.opendistroforelasticsearch.security.auth.HTTPAuthenticator;
import java.util.Objects;

public class AuthDomain
implements Comparable<AuthDomain> {
    private final AuthenticationBackend backend;
    private final HTTPAuthenticator httpAuthenticator;
    private final int order;
    private final boolean challenge;

    public AuthDomain(AuthenticationBackend backend, HTTPAuthenticator httpAuthenticator, boolean challenge, int order) {
        this.backend = Objects.requireNonNull(backend);
        this.httpAuthenticator = httpAuthenticator;
        this.order = order;
        this.challenge = challenge;
    }

    public boolean isChallenge() {
        return this.challenge;
    }

    public AuthenticationBackend getBackend() {
        return this.backend;
    }

    public HTTPAuthenticator getHttpAuthenticator() {
        return this.httpAuthenticator;
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return "AuthDomain [backend=" + this.backend + ", httpAuthenticator=" + this.httpAuthenticator + ", order=" + this.order + ", challenge=" + this.challenge + "]";
    }

    @Override
    public int compareTo(AuthDomain o) {
        return Integer.compare(this.order, o.order);
    }
}

