/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.sink;

import com.amazon.opendistroforelasticsearch.security.auditlog.sink.AuditLogSink;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.DebugSink;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.ExternalESSink;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.InternalESSink;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.KafkaSink;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.Log4JSink;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.NoopSink;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.WebhookSink;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.support.Utils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.threadpool.ThreadPool;

public class SinkProvider {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private static final String FALLBACKSINK_NAME = "fallback";
    private static final String DEFAULTSINK_NAME = "default";
    private final Client clientProvider;
    private final ThreadPool threadPool;
    private final Path configPath;
    private final Settings settings;
    final Map<String, AuditLogSink> allSinks = new HashMap<String, AuditLogSink>();
    AuditLogSink defaultSink;
    AuditLogSink fallbackSink;

    public SinkProvider(Settings settings, Client clientProvider, ThreadPool threadPool, Path configPath) {
        this.settings = settings;
        this.clientProvider = clientProvider;
        this.threadPool = threadPool;
        this.configPath = configPath;
        String fallbackConfigPrefix = "opendistro_security.audit.endpoints.fallback";
        Settings fallbackSinkSettings = settings.getAsSettings(fallbackConfigPrefix);
        if (!fallbackSinkSettings.isEmpty()) {
            this.fallbackSink = this.createSink(FALLBACKSINK_NAME, fallbackSinkSettings.get("type"), settings, fallbackConfigPrefix + ".config");
        }
        if (this.fallbackSink == null) {
            this.fallbackSink = new DebugSink(FALLBACKSINK_NAME, settings, null);
        }
        this.allSinks.put(FALLBACKSINK_NAME, this.fallbackSink);
        this.defaultSink = this.createSink(DEFAULTSINK_NAME, settings.get("opendistro_security.audit.type"), settings, "opendistro_security.audit.config");
        if (this.defaultSink == null) {
            this.log.error("Default endpoint could not be created, auditlog will not work properly.");
            return;
        }
        this.allSinks.put(DEFAULTSINK_NAME, this.defaultSink);
        Map<String, Object> sinkSettingsMap = Utils.convertJsonToxToStructuredMap((ToXContent)settings.getAsSettings("opendistro_security.audit.endpoints"));
        for (Map.Entry<String, Object> sinkEntry : sinkSettingsMap.entrySet()) {
            String sinkName = sinkEntry.getKey();
            if (sinkName.equalsIgnoreCase(FALLBACKSINK_NAME)) continue;
            String type = settings.getAsSettings("opendistro_security.audit.endpoints." + sinkName).get("type");
            if (type == null) {
                this.log.error("No type defined for endpoint {}.", (Object)sinkName);
                continue;
            }
            AuditLogSink sink = this.createSink(sinkName, type, this.settings, "opendistro_security.audit.endpoints." + sinkName + ".config");
            if (sink == null) {
                this.log.error("Endpoint '{}' could not be created, check log file for further information.", (Object)sinkName);
                continue;
            }
            this.allSinks.put(sinkName.toLowerCase(), sink);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("sink '{}' created successfully.", (Object)sinkName);
        }
    }

    public AuditLogSink getSink(String sinkName) {
        return this.allSinks.get(sinkName.toLowerCase());
    }

    public AuditLogSink getDefaultSink() {
        return this.defaultSink;
    }

    public void close() {
        for (AuditLogSink sink : this.allSinks.values()) {
            this.close(sink);
        }
    }

    protected void close(AuditLogSink sink) {
        try {
            this.log.info("Closing {}", (Object)sink.getClass().getSimpleName());
            sink.close();
        }
        catch (Exception ex) {
            this.log.info("Could not close sink '{}' due to '{}'", (Object)sink.getClass().getSimpleName(), (Object)ex.getMessage());
        }
    }

    private final AuditLogSink createSink(String name, String type, Settings settings, String settingsPrefix) {
        AuditLogSink sink = null;
        if (type != null) {
            switch (type.toLowerCase()) {
                case "internal_elasticsearch": {
                    sink = new InternalESSink(name, settings, settingsPrefix, this.configPath, this.clientProvider, this.threadPool, this.fallbackSink);
                    break;
                }
                case "external_elasticsearch": {
                    try {
                        sink = new ExternalESSink(name, settings, settingsPrefix, this.configPath, this.fallbackSink);
                    }
                    catch (Exception e) {
                        this.log.error("Audit logging unavailable: Unable to setup HttpESAuditLog due to", (Throwable)e);
                    }
                    break;
                }
                case "webhook": {
                    try {
                        sink = new WebhookSink(name, settings, settingsPrefix, this.configPath, this.fallbackSink);
                    }
                    catch (Exception e1) {
                        this.log.error("Audit logging unavailable: Unable to setup WebhookAuditLog due to", (Throwable)e1);
                    }
                    break;
                }
                case "debug": {
                    sink = new DebugSink(name, settings, this.fallbackSink);
                    break;
                }
                case "noop": {
                    sink = new NoopSink(name, settings, this.fallbackSink);
                    break;
                }
                case "log4j": {
                    sink = new Log4JSink(name, settings, settingsPrefix, this.fallbackSink);
                    break;
                }
                case "kafka": {
                    sink = new KafkaSink(name, settings, settingsPrefix, this.fallbackSink);
                    break;
                }
                default: {
                    try {
                        Class<?> delegateClass = Class.forName(type);
                        if (AuditLogSink.class.isAssignableFrom(delegateClass)) {
                            try {
                                sink = (AuditLogSink)delegateClass.getConstructor(String.class, Settings.class, String.class, Path.class, Client.class, ThreadPool.class, AuditLogSink.class).newInstance(name, settings, settingsPrefix, this.configPath, this.clientProvider, this.threadPool, this.fallbackSink);
                            }
                            catch (Throwable e) {
                                sink = (AuditLogSink)delegateClass.getConstructor(String.class, Settings.class, String.class, AuditLogSink.class).newInstance(name, settings, settingsPrefix, this.fallbackSink);
                            }
                            break;
                        }
                        this.log.error("Audit logging unavailable: '{}' is not a subclass of {}", (Object)type, (Object)AuditLogSink.class.getSimpleName());
                        break;
                    }
                    catch (Throwable e) {
                        this.log.error("Audit logging unavailable: Cannot instantiate object of class {} due to ", (Object)type, (Object)e);
                    }
                }
            }
        }
        return sink;
    }
}

