/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.sink;

import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditMessage;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.AuditLogSink;
import com.amazon.opendistroforelasticsearch.security.support.HeaderHelper;
import java.io.IOException;
import java.nio.file.Path;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class InternalESSink
extends AuditLogSink {
    private final Client clientProvider;
    final String index;
    final String type;
    private DateTimeFormatter indexPattern;
    private final ThreadPool threadPool;

    public InternalESSink(String name, Settings settings, String settingsPrefix, Path configPath, Client clientProvider, ThreadPool threadPool, AuditLogSink fallbackSink) {
        super(name, settings, settingsPrefix, fallbackSink);
        this.clientProvider = clientProvider;
        Settings sinkSettings = this.getSinkSettings(settingsPrefix);
        this.index = sinkSettings.get("index", "'security-auditlog-'YYYY.MM.dd");
        this.type = sinkSettings.get("type", null);
        this.threadPool = threadPool;
        try {
            this.indexPattern = DateTimeFormat.forPattern((String)this.index);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Unable to parse index pattern due to {}. If you have no date pattern configured you can safely ignore this message", (Object)e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        if (Boolean.parseBoolean(HeaderHelper.getSafeFromHeader(this.threadPool.getThreadContext(), "_opendistro_security_conf_request"))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("audit log of audit log will not be executed");
            }
            return true;
        }
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            IndexRequestBuilder irb = ((IndexRequestBuilder)this.clientProvider.prepareIndex(this.getExpandedIndexName(this.indexPattern, this.index), this.type).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(msg.getAsMap());
            this.threadPool.getThreadContext().putHeader("_opendistro_security_conf_request", "true");
            irb.setTimeout(TimeValue.timeValueMinutes((long)1L));
            irb.execute().actionGet();
            boolean bl = true;
            return bl;
        }
    }
}

