/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.sink;

import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditMessage;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public abstract class AuditLogSink {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Settings settings;
    protected final String settingsPrefix;
    private final String name;
    protected final AuditLogSink fallbackSink;
    private final int retryCount;
    private final long delayMs;

    protected AuditLogSink(String name, Settings settings, String settingsPrefix, AuditLogSink fallbackSink) {
        this.name = name.toLowerCase();
        this.settings = Objects.requireNonNull(settings);
        this.settingsPrefix = settingsPrefix;
        this.fallbackSink = fallbackSink;
        this.retryCount = settings.getAsInt("opendistro_security.audit.config.retry_count", Integer.valueOf(0));
        this.delayMs = settings.getAsLong("opendistro_security.audit.config.retry_delay_ms", Long.valueOf(1000L));
    }

    public boolean isHandlingBackpressure() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public AuditLogSink getFallbackSink() {
        return this.fallbackSink;
    }

    public final void store(AuditMessage msg) {
        if (!this.doStoreWithRetry(msg) && !this.fallbackSink.doStoreWithRetry(msg)) {
            System.err.println(msg.toPrettyString());
        }
    }

    private boolean doStoreWithRetry(AuditMessage msg) {
        if (this.doStore(msg)) {
            return true;
        }
        for (int i = 0; i < this.retryCount; ++i) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retry attempt {}/{} for {} ({})", (Object)(i + 1), (Object)this.retryCount, (Object)this.getName(), this.getClass());
            }
            Uninterruptibles.sleepUninterruptibly((long)this.delayMs, (TimeUnit)TimeUnit.MILLISECONDS);
            if (!this.doStore(msg)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean doStore(AuditMessage var1);

    public void close() throws IOException {
    }

    protected String getExpandedIndexName(DateTimeFormatter indexPattern, String index) {
        if (indexPattern == null) {
            return index;
        }
        return indexPattern.print((ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC));
    }

    protected Settings getSinkSettings(String prefix) {
        return this.settings.getAsSettings(prefix);
    }

    public String toString() {
        return "AudtLogSink: Name: " + this.name + ", type: " + this.getClass().getSimpleName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditLogSink other = (AuditLogSink)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

