/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.routing;

import com.amazon.opendistroforelasticsearch.security.auditlog.config.ThreadPoolConfig;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditMessage;
import com.amazon.opendistroforelasticsearch.security.auditlog.sink.AuditLogSink;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncStoragePool {
    private static final Logger log = LogManager.getLogger(AsyncStoragePool.class);
    private final ExecutorService pool;
    private final ThreadPoolConfig threadPoolConfig;

    public AsyncStoragePool(ThreadPoolConfig threadPoolConfig) {
        this.threadPoolConfig = threadPoolConfig;
        this.pool = AsyncStoragePool.createExecutor(threadPoolConfig);
    }

    public ThreadPoolConfig getConfig() {
        return this.threadPoolConfig;
    }

    public void submit(AuditMessage message, AuditLogSink sink) {
        block2: {
            try {
                this.pool.submit(() -> {
                    sink.store(message);
                    if (log.isTraceEnabled()) {
                        log.trace("stored on delegate {} asynchronously", (Object)sink.getClass().getSimpleName());
                    }
                });
            }
            catch (Exception ex) {
                log.error("Could not submit audit message {} to thread pool for delegate '{}' due to '{}'", (Object)message, (Object)sink.getClass().getSimpleName(), (Object)ex.getMessage());
                if (sink.getFallbackSink() == null) break block2;
                sink.getFallbackSink().store(message);
            }
        }
    }

    private static ThreadPoolExecutor createExecutor(ThreadPoolConfig config) {
        if (log.isDebugEnabled()) {
            log.debug("Create new executor with threadPoolSize: {} and maxQueueLen: {}", (Object)config.getThreadPoolSize(), (Object)config.getThreadPoolMaxQueueLen());
        }
        return new ThreadPoolExecutor(config.getThreadPoolSize(), config.getThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(config.getThreadPoolMaxQueueLen()));
    }

    public void close() {
        if (this.pool != null) {
            this.pool.shutdown();
            try {
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.pool.shutdownNow();
                    if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        log.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

