/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.impl;

import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditCategory;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditMessage;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.support.Utils;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;

public final class RequestResolver {
    private static final Logger log = LogManager.getLogger(RequestResolver.class);

    public static List<AuditMessage> resolve(AuditCategory category, AuditLog.Origin origin, String action, String privilege, String effectiveUser, Boolean securityadmin, String initiatingUser, TransportAddress remoteAddress, TransportRequest request, Map<String, String> headers, Task task, IndexNameExpressionResolver resolver, ClusterService cs, Settings settings, boolean logRequestBody, boolean resolveIndices, boolean resolveBulk, String opendistrosecurityIndex, boolean excludeSensitiveHeaders, Throwable exception) {
        if (resolveBulk && request instanceof BulkShardRequest) {
            BulkItemRequest[] innerRequests = ((BulkShardRequest)request).items();
            ArrayList<AuditMessage> messages = new ArrayList<AuditMessage>(innerRequests.length);
            for (BulkItemRequest ar : innerRequests) {
                DocWriteRequest innerRequest = ar.request();
                AuditMessage msg = RequestResolver.resolveInner(category, effectiveUser, securityadmin, initiatingUser, remoteAddress, action, privilege, origin, innerRequest, headers, task, resolver, cs, settings, logRequestBody, resolveIndices, opendistrosecurityIndex, excludeSensitiveHeaders, exception);
                msg.addShardId(((BulkShardRequest)request).shardId());
                messages.add(msg);
            }
            return messages;
        }
        if (request instanceof BulkShardRequest && category != AuditCategory.FAILED_LOGIN && category != AuditCategory.MISSING_PRIVILEGES && category != AuditCategory.OPENDISTRO_SECURITY_INDEX_ATTEMPT) {
            return Collections.emptyList();
        }
        return Collections.singletonList(RequestResolver.resolveInner(category, effectiveUser, securityadmin, initiatingUser, remoteAddress, action, privilege, origin, request, headers, task, resolver, cs, settings, logRequestBody, resolveIndices, opendistrosecurityIndex, excludeSensitiveHeaders, exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuditMessage resolveInner(AuditCategory category, String effectiveUser, Boolean securityadmin, String initiatingUser, TransportAddress remoteAddress, String action, String priv, AuditLog.Origin origin, Object request, Map<String, String> headers, Task task, IndexNameExpressionResolver resolver, ClusterService cs, Settings settings, boolean logRequestBody, boolean resolveIndices, String opendistrosecurityIndex, boolean excludeSensitiveHeaders, Throwable exception) {
        AuditMessage msg = new AuditMessage(category, cs, origin, AuditLog.Origin.TRANSPORT);
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addRemoteAddress(remoteAddress);
        msg.addAction(action);
        if (request != null) {
            msg.addRequestType(request.getClass().getSimpleName());
        }
        if (securityadmin != null) {
            msg.addIsAdminDn(securityadmin);
        }
        msg.addException(exception);
        msg.addPrivilege(priv);
        msg.addTransportHeaders(headers, excludeSensitiveHeaders);
        if (task != null) {
            msg.addTaskId(task.getId());
            if (task.getParentTaskId() != null && task.getParentTaskId().isSet()) {
                msg.addTaskParentId(task.getParentTaskId().toString());
            }
        }
        if (request instanceof MultiGetRequest.Item) {
            MultiGetRequest.Item item = (MultiGetRequest.Item)request;
            String[] indices = RequestResolver.arrayOrEmpty(item.indices());
            String id = item.id();
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
        } else if (request instanceof CreateIndexRequest) {
            CreateIndexRequest cir = (CreateIndexRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(cir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
            if (logRequestBody) {
                msg.addMapToRequestBody(Utils.convertJsonToxToStructuredMap((ToXContent)cir.settings()));
            }
        } else if (request instanceof UpdateSettingsRequest) {
            UpdateSettingsRequest usr = (UpdateSettingsRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(usr.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
            if (logRequestBody) {
                msg.addMapToRequestBody(Utils.convertJsonToxToStructuredMap((ToXContent)usr.settings()));
            }
        } else if (request instanceof DeleteIndexRequest) {
            DeleteIndexRequest dir = (DeleteIndexRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(dir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
        } else if (request instanceof IndexRequest) {
            IndexRequest ir = (IndexRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            String id = ir.id();
            msg.addShardId(ir.shardId());
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, ir.getContentType(), ir.source(), settings, resolveIndices, logRequestBody, true, opendistrosecurityIndex);
        } else if (request instanceof DeleteRequest) {
            DeleteRequest dr = (DeleteRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(dr.indices());
            String id = dr.id();
            msg.addShardId(dr.shardId());
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
        } else if (request instanceof UpdateRequest) {
            UpdateRequest ur = (UpdateRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ur.indices());
            String id = ur.id();
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
            if (logRequestBody) {
                if (ur.doc() != null) {
                    msg.addTupleToRequestBody(ur.doc() == null ? null : RequestResolver.convertSource(ur.doc().getContentType(), ur.doc().source()));
                }
                if (ur.script() != null) {
                    msg.addMapToRequestBody(ur.script() == null ? null : Utils.convertJsonToxToStructuredMap((ToXContent)ur.script()));
                }
            }
        } else if (request instanceof GetRequest) {
            GetRequest gr = (GetRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(gr.indices());
            String id = gr.id();
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
        } else if (request instanceof SearchRequest) {
            SearchRequest sr = (SearchRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(sr.indices());
            Map<String, Object> sourceAsMap = sr.source() == null ? null : Utils.convertJsonToxToStructuredMap((ToXContent)sr.source());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, XContentType.JSON, sourceAsMap, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
        } else if (request instanceof ClusterUpdateSettingsRequest) {
            if (logRequestBody) {
                ClusterUpdateSettingsRequest cusr = (ClusterUpdateSettingsRequest)request;
                Settings persistentSettings = cusr.persistentSettings();
                Settings transientSettings = cusr.transientSettings();
                try (XContentBuilder builder = null;){
                    builder = XContentFactory.jsonBuilder();
                    builder.startObject();
                    if (persistentSettings != null) {
                        builder.field("persistent_settings", Utils.convertJsonToxToStructuredMap((ToXContent)persistentSettings));
                    }
                    if (transientSettings != null) {
                        builder.field("transient_settings", Utils.convertJsonToxToStructuredMap((ToXContent)persistentSettings));
                    }
                    builder.endObject();
                    msg.addUnescapedJsonToRequestBody(builder == null ? null : Strings.toString((XContentBuilder)builder));
                }
            }
        } else if (request instanceof ReindexRequest) {
            IndexRequest ir = ((ReindexRequest)request).getDestination();
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            String id = ir.id();
            msg.addShardId(ir.shardId());
            msg.addId(id);
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, ir.getContentType(), ir.source(), settings, resolveIndices, logRequestBody, true, opendistrosecurityIndex);
        } else if (request instanceof DeleteByQueryRequest) {
            DeleteByQueryRequest ir = (DeleteByQueryRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
        } else if (request instanceof UpdateByQueryRequest) {
            UpdateByQueryRequest ir = (UpdateByQueryRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
        } else if (request instanceof PutMappingRequest) {
            PutMappingRequest pr = (PutMappingRequest)request;
            Index ci = pr.getConcreteIndex();
            String[] indices = new String[]{};
            msg.addIndices(indices);
            if (ci != null) {
                indices = new String[]{ci.getName()};
            }
            if (logRequestBody) {
                msg.addUnescapedJsonToRequestBody(pr.source());
            }
            if (resolveIndices) {
                msg.addResolvedIndices(indices);
            }
        } else if (request instanceof IndicesRequest) {
            IndicesRequest ir = (IndicesRequest)request;
            String[] indices = RequestResolver.arrayOrEmpty(ir.indices());
            RequestResolver.addIndicesSourceSafe(msg, indices, resolver, cs, null, null, settings, resolveIndices, logRequestBody, false, opendistrosecurityIndex);
        }
        return msg;
    }

    private static void addIndicesSourceSafe(AuditMessage msg, String[] indices, IndexNameExpressionResolver resolver, ClusterService cs, XContentType xContentType, Object source, Settings settings, boolean resolveIndices, boolean addSource, boolean sourceIsSensitive, String opendistrosecurityIndex) {
        HashSet<String> allIndices;
        if (addSource) {
            resolveIndices = true;
        }
        String[] _indices = indices == null ? new String[]{} : indices;
        msg.addIndices(_indices);
        if (resolveIndices) {
            String[] resolvedIndices = resolver == null ? new String[]{} : resolver.concreteIndexNames(cs.state(), IndicesOptions.lenientExpandOpen(), indices);
            msg.addResolvedIndices(resolvedIndices);
            allIndices = new HashSet(resolvedIndices.length + _indices.length);
            allIndices.addAll(Arrays.asList(_indices));
            allIndices.addAll(Arrays.asList(resolvedIndices));
            if (allIndices.contains("_all")) {
                allIndices.add("*");
            }
        } else {
            allIndices = new HashSet<String>(_indices.length);
            allIndices.addAll(Arrays.asList(_indices));
            if (allIndices.contains("_all")) {
                allIndices.add("*");
            }
        }
        WildcardMatcher allIndicesMatcher = WildcardMatcher.from(allIndices);
        if (addSource) {
            if (sourceIsSensitive && source != null) {
                if (!allIndicesMatcher.test(opendistrosecurityIndex)) {
                    if (source instanceof BytesReference) {
                        msg.addTupleToRequestBody(RequestResolver.convertSource(xContentType, (BytesReference)source));
                    } else {
                        msg.addMapToRequestBody((Map)source);
                    }
                }
            } else if (source != null) {
                if (source instanceof BytesReference) {
                    msg.addTupleToRequestBody(RequestResolver.convertSource(xContentType, (BytesReference)source));
                } else {
                    msg.addMapToRequestBody((Map)source);
                }
            }
        }
    }

    private static Tuple<XContentType, BytesReference> convertSource(XContentType type, BytesReference bytes) {
        if (type == null) {
            type = XContentType.JSON;
        }
        return new Tuple((Object)type, (Object)bytes);
    }

    private static String[] arrayOrEmpty(String[] array) {
        if (array == null) {
            return new String[0];
        }
        if (array.length == 1 && array[0] == null) {
            return new String[0];
        }
        return array;
    }
}

