/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.impl;

import com.amazon.opendistroforelasticsearch.security.auditlog.config.AuditConfig;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AbstractAuditLog;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditMessage;
import com.amazon.opendistroforelasticsearch.security.auditlog.routing.AuditMessageRouter;
import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Map;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.greenrobot.eventbus.Subscribe;

public final class AuditLogImpl
extends AbstractAuditLog {
    private final AuditMessageRouter messageRouter;
    private final Settings settings;
    private final boolean messageRouterEnabled;
    private volatile boolean enabled;
    private final Thread shutdownHook;

    public AuditLogImpl(Settings settings, Path configPath, Client clientProvider, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService) {
        this(settings, configPath, clientProvider, threadPool, resolver, clusterService, null);
    }

    public AuditLogImpl(Settings settings, Path configPath, Client clientProvider, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService, Environment environment) {
        super(settings, threadPool, resolver, clusterService, environment);
        this.settings = settings;
        this.messageRouter = new AuditMessageRouter(settings, clientProvider, threadPool, configPath);
        this.messageRouterEnabled = this.messageRouter.isEnabled();
        this.log.info("Message routing enabled: {}", (Object)this.messageRouterEnabled);
        SpecialPermission.check();
        this.shutdownHook = AccessController.doPrivileged(this::addShutdownHook);
        this.log.debug("Shutdown hook {} registered", (Object)this.shutdownHook);
    }

    @Override
    @Subscribe
    public void setConfig(AuditConfig auditConfig) {
        this.enabled = auditConfig.isEnabled() && this.messageRouterEnabled;
        this.onAuditConfigFilterChanged(auditConfig.getFilter());
        this.onComplianceConfigChanged(auditConfig.getCompliance());
    }

    @Override
    protected void enableRoutes() {
        if (this.messageRouterEnabled) {
            this.messageRouter.enableRoutes(this.settings);
        }
    }

    private Thread addShutdownHook() {
        Thread shutdownHook = new Thread(() -> this.messageRouter.close());
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return shutdownHook;
    }

    private Boolean removeShutdownHook() {
        return Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    @Override
    public void close() throws IOException {
        this.log.info("Closing {}", (Object)this.getClass().getSimpleName());
        SpecialPermission.check();
        try {
            boolean removed = AccessController.doPrivileged(this::removeShutdownHook);
            if (removed) {
                this.log.debug("Shutdown hook {} unregistered", (Object)this.shutdownHook);
                this.shutdownHook.run();
            } else {
                this.log.warn("Shutdown hook {} is not registered", (Object)this.shutdownHook);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug("Fail to unregister shutdown hook {}. Shutdown is in progress.", (Object)this.shutdownHook, (Object)e);
        }
    }

    @Override
    protected void save(AuditMessage msg) {
        if (this.enabled) {
            this.messageRouter.route(msg);
        }
    }

    @Override
    public void logFailedLogin(String effectiveUser, boolean securityAdmin, String initiatingUser, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logFailedLogin(effectiveUser, securityAdmin, initiatingUser, request, task);
        }
    }

    @Override
    public void logFailedLogin(String effectiveUser, boolean securityAdmin, String initiatingUser, RestRequest request) {
        if (this.enabled) {
            super.logFailedLogin(effectiveUser, securityAdmin, initiatingUser, request);
        }
    }

    @Override
    public void logSucceededLogin(String effectiveUser, boolean securityAdmin, String initiatingUser, TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logSucceededLogin(effectiveUser, securityAdmin, initiatingUser, request, action, task);
        }
    }

    @Override
    public void logSucceededLogin(String effectiveUser, boolean securityAdmin, String initiatingUser, RestRequest request) {
        if (this.enabled) {
            super.logSucceededLogin(effectiveUser, securityAdmin, initiatingUser, request);
        }
    }

    @Override
    public void logMissingPrivileges(String privilege, String effectiveUser, RestRequest request) {
        if (this.enabled) {
            super.logMissingPrivileges(privilege, effectiveUser, request);
        }
    }

    @Override
    public void logGrantedPrivileges(String effectiveUser, RestRequest request) {
        if (this.enabled) {
            super.logGrantedPrivileges(effectiveUser, request);
        }
    }

    @Override
    public void logMissingPrivileges(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logMissingPrivileges(privilege, request, task);
        }
    }

    @Override
    public void logGrantedPrivileges(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logGrantedPrivileges(privilege, request, task);
        }
    }

    @Override
    public void logIndexEvent(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logIndexEvent(privilege, request, task);
        }
    }

    @Override
    public void logBadHeaders(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logBadHeaders(request, action, task);
        }
    }

    @Override
    public void logBadHeaders(RestRequest request) {
        if (this.enabled) {
            super.logBadHeaders(request);
        }
    }

    @Override
    public void logSecurityIndexAttempt(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logSecurityIndexAttempt(request, action, task);
        }
    }

    @Override
    public void logSSLException(TransportRequest request, Throwable t, String action, Task task) {
        if (this.enabled) {
            super.logSSLException(request, t, action, task);
        }
    }

    @Override
    public void logSSLException(RestRequest request, Throwable t) {
        if (this.enabled) {
            super.logSSLException(request, t);
        }
    }

    @Override
    public void logDocumentRead(String index, String id, ShardId shardId, Map<String, String> fieldNameValues) {
        if (this.enabled) {
            super.logDocumentRead(index, id, shardId, fieldNameValues);
        }
    }

    @Override
    public void logDocumentWritten(ShardId shardId, GetResult originalResult, Engine.Index currentIndex, Engine.IndexResult result) {
        if (this.enabled) {
            super.logDocumentWritten(shardId, originalResult, currentIndex, result);
        }
    }

    @Override
    public void logDocumentDeleted(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        if (this.enabled) {
            super.logDocumentDeleted(shardId, delete, result);
        }
    }

    @Override
    protected void logExternalConfig() {
        if (this.enabled) {
            super.logExternalConfig();
        }
    }
}

