/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.impl;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.auditlog.AuditLog;
import com.amazon.opendistroforelasticsearch.security.auditlog.config.AuditConfig;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditCategory;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditMessage;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.RequestResolver;
import com.amazon.opendistroforelasticsearch.security.compliance.ComplianceConfig;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.support.Utils;
import com.amazon.opendistroforelasticsearch.security.support.Base64Helper;
import com.amazon.opendistroforelasticsearch.security.user.User;
import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public abstract class AbstractAuditLog
implements AuditLog {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final ThreadPool threadPool;
    private final IndexNameExpressionResolver resolver;
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile AuditConfig.Filter auditConfigFilter;
    private final String opendistrosecurityIndex;
    private volatile ComplianceConfig complianceConfig;
    private final Environment environment;
    private AtomicBoolean externalConfigLogged = new AtomicBoolean();
    private static final List<String> writeClasses = new ArrayList<String>();

    protected abstract void enableRoutes();

    protected AbstractAuditLog(Settings settings, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService, Environment environment) {
        writeClasses.add(IndexRequest.class.getSimpleName());
        writeClasses.add(UpdateRequest.class.getSimpleName());
        writeClasses.add(BulkRequest.class.getSimpleName());
        writeClasses.add(BulkShardRequest.class.getSimpleName());
        writeClasses.add(DeleteRequest.class.getSimpleName());
        this.threadPool = threadPool;
        this.settings = settings;
        this.resolver = resolver;
        this.clusterService = clusterService;
        this.opendistrosecurityIndex = settings.get("opendistro_security.config_index_name", ".opendistro_security");
        this.environment = environment;
    }

    protected void onAuditConfigFilterChanged(AuditConfig.Filter auditConfigFilter) {
        this.auditConfigFilter = auditConfigFilter;
        this.auditConfigFilter.log(this.log);
    }

    protected void onComplianceConfigChanged(ComplianceConfig complianceConfig) {
        this.complianceConfig = complianceConfig;
        this.enableRoutes();
        this.complianceConfig.log(this.log);
        this.logExternalConfig();
    }

    @Override
    public ComplianceConfig getComplianceConfig() {
        return this.complianceConfig;
    }

    @Override
    public void logFailedLogin(String effectiveUser, boolean securityadmin, String initiatingUser, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditCategory.FAILED_LOGIN, action, effectiveUser, request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.FAILED_LOGIN, this.getOrigin(), action, null, effectiveUser, securityadmin, initiatingUser, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.opendistrosecurityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logFailedLogin(String effectiveUser, boolean securityadmin, String initiatingUser, RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.FAILED_LOGIN, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.FAILED_LOGIN, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addIsAdminDn(securityadmin);
        this.save(msg);
    }

    @Override
    public void logSucceededLogin(String effectiveUser, boolean securityadmin, String initiatingUser, TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditCategory.AUTHENTICATED, action, effectiveUser, request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.AUTHENTICATED, this.getOrigin(), action, null, effectiveUser, securityadmin, initiatingUser, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.opendistrosecurityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logSucceededLogin(String effectiveUser, boolean securityadmin, String initiatingUser, RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.AUTHENTICATED, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.AUTHENTICATED, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addInitiatingUser(initiatingUser);
        msg.addEffectiveUser(effectiveUser);
        msg.addIsAdminDn(securityadmin);
        this.save(msg);
    }

    @Override
    public void logMissingPrivileges(String privilege, String effectiveUser, RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.MISSING_PRIVILEGES, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.MISSING_PRIVILEGES, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addEffectiveUser(effectiveUser);
        this.save(msg);
    }

    @Override
    public void logGrantedPrivileges(String effectiveUser, RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.GRANTED_PRIVILEGES, effectiveUser, request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.GRANTED_PRIVILEGES, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        msg.addRemoteAddress(this.getRemoteAddress());
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addEffectiveUser(effectiveUser);
        this.save(msg);
    }

    @Override
    public void logMissingPrivileges(String privilege, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditCategory.MISSING_PRIVILEGES, privilege, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.MISSING_PRIVILEGES, this.getOrigin(), action, privilege, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.opendistrosecurityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logGrantedPrivileges(String privilege, TransportRequest request, Task task) {
        String action = null;
        if (!this.checkTransportFilter(AuditCategory.GRANTED_PRIVILEGES, privilege, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.GRANTED_PRIVILEGES, this.getOrigin(), action, privilege, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.opendistrosecurityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logIndexEvent(String privilege, TransportRequest request, Task task) {
        if (!this.checkTransportFilter(AuditCategory.INDEX_EVENT, privilege, this.getUser(), request)) {
            return;
        }
        if (!privilege.startsWith("indices:admin/")) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.INDEX_EVENT, this.getOrigin(), null, privilege, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.opendistrosecurityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        msgs.forEach(this::save);
    }

    @Override
    public void logBadHeaders(TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditCategory.BAD_HEADERS, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.BAD_HEADERS, this.getOrigin(), action, null, this.getUser(), null, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.opendistrosecurityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logBadHeaders(RestRequest request) {
        if (!this.checkRestFilter(AuditCategory.BAD_HEADERS, this.getUser(), request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.BAD_HEADERS, this.clusterService, this.getOrigin(), AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addEffectiveUser(this.getUser());
        this.save(msg);
    }

    @Override
    public void logSecurityIndexAttempt(TransportRequest request, String action, Task task) {
        if (!this.checkTransportFilter(AuditCategory.OPENDISTRO_SECURITY_INDEX_ATTEMPT, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.OPENDISTRO_SECURITY_INDEX_ATTEMPT, this.getOrigin(), action, null, this.getUser(), false, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.opendistrosecurityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), null);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logSSLException(TransportRequest request, Throwable t, String action, Task task) {
        if (!this.checkTransportFilter(AuditCategory.SSL_EXCEPTION, action, this.getUser(), request)) {
            return;
        }
        TransportAddress remoteAddress = this.getRemoteAddress();
        List<AuditMessage> msgs = RequestResolver.resolve(AuditCategory.SSL_EXCEPTION, AuditLog.Origin.TRANSPORT, action, null, this.getUser(), false, null, remoteAddress, request, this.getThreadContextHeaders(), task, this.resolver, this.clusterService, this.settings, this.auditConfigFilter.shouldLogRequestBody(), this.auditConfigFilter.shouldResolveIndices(), this.auditConfigFilter.shouldResolveBulkRequests(), this.opendistrosecurityIndex, this.auditConfigFilter.shouldExcludeSensitiveHeaders(), t);
        for (AuditMessage msg : msgs) {
            this.save(msg);
        }
    }

    @Override
    public void logSSLException(RestRequest request, Throwable t) {
        if (!this.checkRestFilter(AuditCategory.SSL_EXCEPTION, this.getUser(), request)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.SSL_EXCEPTION, this.clusterService, AuditLog.Origin.REST, AuditLog.Origin.REST);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addRestRequestInfo(request, this.auditConfigFilter);
        msg.addException(t);
        msg.addEffectiveUser(this.getUser());
        this.save(msg);
    }

    @Override
    public void logDocumentRead(String index, String id, ShardId shardId, Map<String, String> fieldNameValues) {
        String effectiveUser;
        ComplianceConfig complianceConfig = this.getComplianceConfig();
        if (complianceConfig == null || !complianceConfig.readHistoryEnabledForIndex(index)) {
            return;
        }
        String initiatingRequestClass = this.threadPool.getThreadContext().getHeader("_opendistro_security_initial_action_class_header");
        if (initiatingRequestClass != null && writeClasses.contains(initiatingRequestClass)) {
            return;
        }
        AuditCategory category = this.opendistrosecurityIndex.equals(index) ? AuditCategory.COMPLIANCE_INTERNAL_CONFIG_READ : AuditCategory.COMPLIANCE_DOC_READ;
        if (!this.checkComplianceFilter(category, effectiveUser = this.getUser(), this.getOrigin(), complianceConfig)) {
            return;
        }
        if (fieldNameValues != null && !fieldNameValues.isEmpty()) {
            AuditMessage msg = new AuditMessage(category, this.clusterService, this.getOrigin(), null);
            TransportAddress remoteAddress = this.getRemoteAddress();
            msg.addRemoteAddress(remoteAddress);
            msg.addEffectiveUser(effectiveUser);
            msg.addIndices(new String[]{index});
            msg.addResolvedIndices(new String[]{index});
            msg.addShardId(shardId);
            msg.addId(id);
            try {
                if (complianceConfig.shouldLogReadMetadataOnly()) {
                    try {
                        XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
                        builder.startObject();
                        builder.field("field_names", fieldNameValues.keySet());
                        builder.endObject();
                        builder.close();
                        msg.addUnescapedJsonToRequestBody(Strings.toString((XContentBuilder)builder));
                    }
                    catch (IOException e) {
                        this.log.error(e.toString(), (Throwable)e);
                    }
                } else if (this.opendistrosecurityIndex.equals(index) && !"tattr".equals(id)) {
                    try {
                        Map<String, String> map = fieldNameValues.entrySet().stream().collect(Collectors.toMap(entry -> "id", entry -> new String(BaseEncoding.base64().decode((CharSequence)entry.getValue()), StandardCharsets.UTF_8)));
                        msg.addMapToRequestBody(Utils.convertJsonToxToStructuredMap(map.get("id")));
                    }
                    catch (Exception e) {
                        msg.addMapToRequestBody(new HashMap<String, Object>(fieldNameValues));
                    }
                } else {
                    msg.addMapToRequestBody(new HashMap<String, Object>(fieldNameValues));
                }
            }
            catch (Exception e) {
                this.log.error("Unable to generate request body for {} and {}", (Object)msg.toPrettyString(), fieldNameValues, (Object)e);
            }
            this.save(msg);
        }
    }

    @Override
    public void logDocumentWritten(ShardId shardId, GetResult originalResult, Engine.Index currentIndex, Engine.IndexResult result) {
        String effectiveUser;
        ComplianceConfig complianceConfig = this.getComplianceConfig();
        if (complianceConfig == null || !complianceConfig.writeHistoryEnabledForIndex(shardId.getIndexName())) {
            return;
        }
        AuditCategory category = this.opendistrosecurityIndex.equals(shardId.getIndexName()) ? AuditCategory.COMPLIANCE_INTERNAL_CONFIG_WRITE : AuditCategory.COMPLIANCE_DOC_WRITE;
        if (!this.checkComplianceFilter(category, effectiveUser = this.getUser(), this.getOrigin(), complianceConfig)) {
            return;
        }
        AuditMessage msg = new AuditMessage(category, this.clusterService, this.getOrigin(), null);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(new String[]{shardId.getIndexName()});
        msg.addResolvedIndices(new String[]{shardId.getIndexName()});
        msg.addId(currentIndex.id());
        msg.addShardId(shardId);
        msg.addComplianceDocVersion(result.getVersion());
        msg.addComplianceOperation(result.isCreated() ? AuditLog.Operation.CREATE : AuditLog.Operation.UPDATE);
        if (complianceConfig.shouldLogDiffsForWrite() && originalResult != null && originalResult.isExists() && originalResult.internalSourceRef() != null) {
            try {
                JsonNode diffnode;
                String originalSource = null;
                String currentSource = null;
                if (this.opendistrosecurityIndex.equals(shardId.getIndexName())) {
                    Object base64;
                    XContentParser parser;
                    try {
                        parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)originalResult.internalSourceRef(), (XContentType)XContentType.JSON);
                        try {
                            base64 = parser.map().values().iterator().next();
                            originalSource = base64 instanceof String ? new String(BaseEncoding.base64().decode((CharSequence)((String)base64))) : XContentHelper.convertToJson((BytesReference)originalResult.internalSourceRef(), (boolean)false, (XContentType)XContentType.JSON);
                        }
                        finally {
                            if (parser != null) {
                                parser.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                    }
                    try {
                        parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)currentIndex.source(), (XContentType)XContentType.JSON);
                        try {
                            base64 = parser.map().values().iterator().next();
                            currentSource = base64 instanceof String ? new String(BaseEncoding.base64().decode((CharSequence)((String)base64))) : XContentHelper.convertToJson((BytesReference)currentIndex.source(), (boolean)false, (XContentType)XContentType.JSON);
                        }
                        finally {
                            if (parser != null) {
                                parser.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                    }
                } else {
                    originalSource = XContentHelper.convertToJson((BytesReference)originalResult.internalSourceRef(), (boolean)false, (XContentType)XContentType.JSON);
                    currentSource = XContentHelper.convertToJson((BytesReference)currentIndex.source(), (boolean)false, (XContentType)XContentType.JSON);
                }
                msg.addComplianceWriteDiffSource((diffnode = JsonDiff.asJson((JsonNode)DefaultObjectMapper.objectMapper.readTree(originalSource), (JsonNode)DefaultObjectMapper.objectMapper.readTree(currentSource))).size() == 0 ? "" : diffnode.toString());
            }
            catch (Exception e) {
                this.log.error("Unable to generate diff for {}", (Object)msg.toPrettyString(), (Object)e);
            }
        }
        if (!complianceConfig.shouldLogWriteMetadataOnly()) {
            if (this.opendistrosecurityIndex.equals(shardId.getIndexName())) {
                try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)currentIndex.source(), (XContentType)XContentType.JSON);){
                    Object base64 = parser.map().values().iterator().next();
                    if (base64 instanceof String) {
                        msg.addUnescapedJsonToRequestBody(new String(BaseEncoding.base64().decode((CharSequence)((String)base64))));
                    } else {
                        msg.addTupleToRequestBody((Tuple<XContentType, BytesReference>)new Tuple((Object)XContentType.JSON, (Object)currentIndex.source()));
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            } else {
                msg.addTupleToRequestBody((Tuple<XContentType, BytesReference>)new Tuple((Object)XContentType.JSON, (Object)currentIndex.source()));
            }
        }
        this.save(msg);
    }

    @Override
    public void logDocumentDeleted(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        String effectiveUser = this.getUser();
        ComplianceConfig complianceConfig = this.getComplianceConfig();
        if (complianceConfig == null || !complianceConfig.isEnabled() || !this.checkComplianceFilter(AuditCategory.COMPLIANCE_DOC_WRITE, effectiveUser, this.getOrigin(), complianceConfig)) {
            return;
        }
        AuditMessage msg = new AuditMessage(AuditCategory.COMPLIANCE_DOC_WRITE, this.clusterService, this.getOrigin(), null);
        TransportAddress remoteAddress = this.getRemoteAddress();
        msg.addRemoteAddress(remoteAddress);
        msg.addEffectiveUser(effectiveUser);
        msg.addIndices(new String[]{shardId.getIndexName()});
        msg.addResolvedIndices(new String[]{shardId.getIndexName()});
        msg.addId(delete.id());
        msg.addShardId(shardId);
        msg.addComplianceDocVersion(result.getVersion());
        msg.addComplianceOperation(AuditLog.Operation.DELETE);
        this.save(msg);
    }

    protected void logExternalConfig() {
        ComplianceConfig complianceConfig = this.getComplianceConfig();
        if (complianceConfig == null || !complianceConfig.isEnabled() || !complianceConfig.shouldLogExternalConfig() || !this.checkComplianceFilter(AuditCategory.COMPLIANCE_EXTERNAL_CONFIG, null, this.getOrigin(), complianceConfig) || this.externalConfigLogged.getAndSet(true)) {
            return;
        }
        this.log.info("logging external config");
        Map<String, Object> configAsMap = Utils.convertJsonToxToStructuredMap((ToXContent)this.settings);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        Map<String, String> envAsMap = AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                return System.getenv();
            }
        });
        Map propsAsMap = AccessController.doPrivileged(new PrivilegedAction<Map>(){

            @Override
            public Map run() {
                return System.getProperties();
            }
        });
        String sha256 = DigestUtils.sha256Hex((String)(configAsMap.toString() + envAsMap.toString() + propsAsMap.toString()));
        AuditMessage msg = new AuditMessage(AuditCategory.COMPLIANCE_EXTERNAL_CONFIG, this.clusterService, null, null);
        try (XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
            builder.startObject();
            builder.startObject("external_configuration");
            builder.field("elasticsearch_yml", configAsMap);
            builder.field("os_environment", envAsMap);
            builder.field("java_properties", propsAsMap);
            builder.field("sha256_checksum", sha256);
            builder.endObject();
            builder.endObject();
            builder.close();
            msg.addUnescapedJsonToRequestBody(Strings.toString((XContentBuilder)builder));
        }
        catch (Exception e) {
            this.log.error("Unable to build message", (Throwable)e);
        }
        HashMap<String, Path> paths = new HashMap<String, Path>();
        for (String key : this.settings.keySet()) {
            String value;
            if (!key.startsWith("opendistro_security") || !key.contains("filepath") && !key.contains("file_path") || (value = this.settings.get(key)) == null || value.isEmpty()) continue;
            Path path = value.startsWith("/") ? Paths.get(value, new String[0]) : this.environment.configFile().resolve(value);
            paths.put(key, path);
        }
        msg.addFileInfos(paths);
        this.save(msg);
    }

    private AuditLog.Origin getOrigin() {
        String origin = (String)this.threadPool.getThreadContext().getTransient("_opendistro_security_origin");
        if (origin == null && this.threadPool.getThreadContext().getHeader("_opendistro_security_origin_header") != null) {
            origin = this.threadPool.getThreadContext().getHeader("_opendistro_security_origin_header");
        }
        return origin == null ? null : AuditLog.Origin.valueOf(origin);
    }

    private TransportAddress getRemoteAddress() {
        TransportAddress address = (TransportAddress)this.threadPool.getThreadContext().getTransient("_opendistro_security_remote_address");
        if (address == null && this.threadPool.getThreadContext().getHeader("_opendistro_security_remote_address_header") != null) {
            address = new TransportAddress((InetSocketAddress)Base64Helper.deserializeObject(this.threadPool.getThreadContext().getHeader("_opendistro_security_remote_address_header")));
        }
        return address;
    }

    private String getUser() {
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        if (user == null && this.threadPool.getThreadContext().getHeader("_opendistro_security_user_header") != null) {
            user = (User)Base64Helper.deserializeObject(this.threadPool.getThreadContext().getHeader("_opendistro_security_user_header"));
        }
        return user == null ? null : user.getName();
    }

    private Map<String, String> getThreadContextHeaders() {
        return this.threadPool.getThreadContext().getHeaders();
    }

    @VisibleForTesting
    boolean checkTransportFilter(AuditCategory category, String action, String effectiveUser, TransportRequest request) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Check category:{}, action:{}, effectiveUser:{}, request:{}", (Object)category, (Object)action, (Object)effectiveUser, request == null ? null : request.getClass().getSimpleName());
        }
        if (!this.auditConfigFilter.isTransportApiAuditEnabled()) {
            return false;
        }
        if (action != null && action.startsWith("internal:")) {
            return false;
        }
        if (this.auditConfigFilter.isAuditDisabled(effectiveUser)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped audit log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if (request != null && (this.auditConfigFilter.isRequestAuditDisabled(action) || this.auditConfigFilter.isRequestAuditDisabled(request.getClass().getSimpleName()))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped audit log message because request {} is ignored", (Object)(action + "#" + request.getClass().getSimpleName()));
            }
            return false;
        }
        if (!this.auditConfigFilter.getDisabledTransportCategories().contains((Object)category)) {
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Skipped audit log message because category {} not enabled", (Object)category);
        }
        return false;
    }

    private boolean checkComplianceFilter(AuditCategory category, String effectiveUser, AuditLog.Origin origin, ComplianceConfig complianceConfig) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Check for COMPLIANCE category:{}, effectiveUser:{}, origin: {}", (Object)category, (Object)effectiveUser, (Object)origin);
        }
        if (origin == AuditLog.Origin.LOCAL && effectiveUser == null && category != AuditCategory.COMPLIANCE_EXTERNAL_CONFIG) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped compliance log message because of null user and local origin");
            }
            return false;
        }
        if ((category == AuditCategory.COMPLIANCE_DOC_READ || category == AuditCategory.COMPLIANCE_INTERNAL_CONFIG_READ) && effectiveUser != null && complianceConfig.isComplianceReadAuditDisabled(effectiveUser)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped compliance log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if ((category == AuditCategory.COMPLIANCE_DOC_WRITE || category == AuditCategory.COMPLIANCE_INTERNAL_CONFIG_WRITE) && effectiveUser != null && complianceConfig.isComplianceWriteAuditDisabled(effectiveUser)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped compliance log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean checkRestFilter(AuditCategory category, String effectiveUser, RestRequest request) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Check for REST category:{}, effectiveUser:{}, request:{}", (Object)category, (Object)effectiveUser, (Object)(request == null ? null : request.path()));
        }
        if (!this.auditConfigFilter.isRestApiAuditEnabled()) {
            return false;
        }
        if (this.auditConfigFilter.isAuditDisabled(effectiveUser)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped audit log message because of user {} is ignored", (Object)effectiveUser);
            }
            return false;
        }
        if (request != null && this.auditConfigFilter.isRequestAuditDisabled(request.path())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipped audit log message because request {} is ignored", (Object)request.path());
            }
            return false;
        }
        if (!this.auditConfigFilter.getDisabledRestCategories().contains((Object)category)) {
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Skipped audit log message because category {} not enabled", (Object)category);
        }
        return false;
    }

    protected abstract void save(AuditMessage var1);
}

