/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.config;

import org.elasticsearch.common.settings.Settings;

public class ThreadPoolConfig {
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final int DEFAULT_THREAD_POOL_MAX_QUEUE_LEN = 100000;
    private final int threadPoolSize;
    private final int threadPoolMaxQueueLen;

    public ThreadPoolConfig(int threadPoolSize, int threadPoolMaxQueueLen) {
        if (threadPoolSize <= 0) {
            throw new IllegalArgumentException("Incorrect thread pool size: " + threadPoolSize + " configured for audit logging.");
        }
        if (threadPoolMaxQueueLen <= 0) {
            throw new IllegalArgumentException("Incorrect thread pool queue length: " + threadPoolMaxQueueLen + " configured for audit logging.");
        }
        this.threadPoolSize = threadPoolSize;
        this.threadPoolMaxQueueLen = threadPoolMaxQueueLen;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getThreadPoolMaxQueueLen() {
        return this.threadPoolMaxQueueLen;
    }

    public static ThreadPoolConfig getConfig(Settings settings) {
        int threadPoolSize = settings.getAsInt("opendistro_security.audit.threadpool.size", Integer.valueOf(10));
        int threadPoolMaxQueueLen = settings.getAsInt("opendistro_security.audit.threadpool.max_queue_len", Integer.valueOf(100000));
        return new ThreadPoolConfig(threadPoolSize, threadPoolMaxQueueLen);
    }
}

