/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.auditlog.config;

import com.amazon.opendistroforelasticsearch.security.DefaultObjectMapper;
import com.amazon.opendistroforelasticsearch.security.auditlog.impl.AuditCategory;
import com.amazon.opendistroforelasticsearch.security.compliance.ComplianceConfig;
import com.amazon.opendistroforelasticsearch.security.dlic.rest.support.Utils;
import com.amazon.opendistroforelasticsearch.security.support.ConfigConstants;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuditConfig {
    public static final List<String> DEFAULT_IGNORED_USERS = Collections.singletonList("kibanaserver");
    private static Set<String> FIELDS = DefaultObjectMapper.getFields(AuditConfig.class);
    @JsonProperty(value="enabled")
    private final boolean auditLogEnabled;
    @JsonProperty(value="audit")
    private final Filter filter;
    private final ComplianceConfig compliance;
    public static final List<String> DEPRECATED_KEYS = ImmutableList.of((Object)"opendistro_security.audit.enable_rest", (Object)"opendistro_security.audit.config.disabled_rest_categories", (Object)"opendistro_security.audit.enable_transport", (Object)"opendistro_security.audit.config.disabled_transport_categories", (Object)"opendistro_security.audit.log_request_body", (Object)"opendistro_security.audit.resolve_indices", (Object)"opendistro_security.audit.exclude_sensitive_headers", (Object)"opendistro_security.audit.resolve_bulk_requests", (Object)"opendistro_security.audit.ignore_users", (Object)"opendistro_security.audit.ignore_requests", (Object)"opendistro_security.compliance.history.internal_config_enabled", (Object)"opendistro_security.compliance.history.external_config_enabled", (Object[])new String[]{"opendistro_security.compliance.history.read.metadata_only", "opendistro_security.compliance.history.read.ignore_users", "opendistro_security.compliance.history.read.watched_fields", "opendistro_security.compliance.history.write.metadata_only", "opendistro_security.compliance.history.write.log_diffs", "opendistro_security.compliance.history.write.ignore_users", "opendistro_security.compliance.history.write.watched_indices"});
    public static final Set<String> FIELD_PATHS = Sets.union(Utils.generateFieldResourcePaths(FIELDS, "/"), (Set)Sets.union(Utils.generateFieldResourcePaths(Filter.access$000(), "/audit/"), Utils.generateFieldResourcePaths(ComplianceConfig.FIELDS, "/compliance/")));

    private AuditConfig() {
        this(true, null, null);
    }

    public boolean isEnabled() {
        return this.auditLogEnabled;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public ComplianceConfig getCompliance() {
        return this.compliance;
    }

    @VisibleForTesting
    public AuditConfig(boolean auditLogEnabled, Filter filter, ComplianceConfig compliance) {
        this.auditLogEnabled = auditLogEnabled;
        this.filter = filter != null ? filter : Filter.DEFAULT;
        this.compliance = compliance != null ? compliance : ComplianceConfig.DEFAULT;
    }

    public static AuditConfig from(Settings settings) {
        return new AuditConfig(true, Filter.from(settings), ComplianceConfig.from(settings));
    }

    public static Set<String> getDeprecatedKeys(Settings settings) {
        return DEPRECATED_KEYS.stream().filter(arg_0 -> ((Settings)settings).hasValue(arg_0)).collect(Collectors.toSet());
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Filter {
        @VisibleForTesting
        public static final Filter DEFAULT = Filter.from(Settings.EMPTY);
        private static Set<String> FIELDS = DefaultObjectMapper.getFields(Filter.class);
        private final boolean isRestApiAuditEnabled;
        private final boolean isTransportApiAuditEnabled;
        private final boolean resolveBulkRequests;
        private final boolean logRequestBody;
        private final boolean resolveIndices;
        private final boolean excludeSensitiveHeaders;
        @JsonProperty(value="ignore_users")
        private final Set<String> ignoredAuditUsers;
        @JsonProperty(value="ignore_requests")
        private final Set<String> ignoredAuditRequests;
        private final WildcardMatcher ignoredAuditUsersMatcher;
        private final WildcardMatcher ignoredAuditRequestsMatcher;
        private final Set<AuditCategory> disabledRestCategories;
        private final Set<AuditCategory> disabledTransportCategories;

        @VisibleForTesting
        Filter(boolean isRestApiAuditEnabled, boolean isTransportApiAuditEnabled, boolean resolveBulkRequests, boolean logRequestBody, boolean resolveIndices, boolean excludeSensitiveHeaders, Set<String> ignoredAuditUsers, Set<String> ignoredAuditRequests, Set<AuditCategory> disabledRestCategories, Set<AuditCategory> disabledTransportCategories) {
            this.isRestApiAuditEnabled = isRestApiAuditEnabled;
            this.isTransportApiAuditEnabled = isTransportApiAuditEnabled;
            this.resolveBulkRequests = resolveBulkRequests;
            this.logRequestBody = logRequestBody;
            this.resolveIndices = resolveIndices;
            this.excludeSensitiveHeaders = excludeSensitiveHeaders;
            this.ignoredAuditUsers = ignoredAuditUsers;
            this.ignoredAuditUsersMatcher = WildcardMatcher.from(ignoredAuditUsers);
            this.ignoredAuditRequests = ignoredAuditRequests;
            this.ignoredAuditRequestsMatcher = WildcardMatcher.from(ignoredAuditRequests);
            this.disabledRestCategories = disabledRestCategories;
            this.disabledTransportCategories = disabledTransportCategories;
        }

        @JsonCreator
        @VisibleForTesting
        public static Filter from(Map<String, Object> properties) throws JsonProcessingException {
            if (!FIELDS.containsAll(properties.keySet())) {
                throw new UnrecognizedPropertyException(null, "Unrecognized field(s) present in the input data for audit filter config", null, Filter.class, null, null);
            }
            boolean isRestApiAuditEnabled = DefaultObjectMapper.getOrDefault(properties, "enable_rest", true);
            boolean isTransportAuditEnabled = DefaultObjectMapper.getOrDefault(properties, "enable_transport", true);
            boolean resolveBulkRequests = DefaultObjectMapper.getOrDefault(properties, "resolve_bulk_requests", false);
            boolean logRequestBody = DefaultObjectMapper.getOrDefault(properties, "log_request_body", true);
            boolean resolveIndices = DefaultObjectMapper.getOrDefault(properties, "resolve_indices", true);
            boolean excludeSensitiveHeaders = DefaultObjectMapper.getOrDefault(properties, "exclude_sensitive_headers", true);
            Set<AuditCategory> disabledRestCategories = AuditCategory.parse((Collection<String>)DefaultObjectMapper.getOrDefault(properties, "disabled_rest_categories", ConfigConstants.OPENDISTRO_SECURITY_AUDIT_DISABLED_CATEGORIES_DEFAULT));
            Set<AuditCategory> disabledTransportCategories = AuditCategory.parse((Collection<String>)DefaultObjectMapper.getOrDefault(properties, "disabled_transport_categories", ConfigConstants.OPENDISTRO_SECURITY_AUDIT_DISABLED_CATEGORIES_DEFAULT));
            ImmutableSet ignoredAuditUsers = ImmutableSet.copyOf((Collection)DefaultObjectMapper.getOrDefault(properties, "ignore_users", DEFAULT_IGNORED_USERS));
            ImmutableSet ignoreAuditRequests = ImmutableSet.copyOf((Collection)DefaultObjectMapper.getOrDefault(properties, "ignore_requests", Collections.emptyList()));
            return new Filter(isRestApiAuditEnabled, isTransportAuditEnabled, resolveBulkRequests, logRequestBody, resolveIndices, excludeSensitiveHeaders, (Set<String>)ignoredAuditUsers, (Set<String>)ignoreAuditRequests, disabledRestCategories, disabledTransportCategories);
        }

        public static Filter from(Settings settings) {
            boolean isRestApiAuditEnabled = settings.getAsBoolean("opendistro_security.audit.enable_rest", Boolean.valueOf(true));
            boolean isTransportAuditEnabled = settings.getAsBoolean("opendistro_security.audit.enable_transport", Boolean.valueOf(true));
            boolean resolveBulkRequests = settings.getAsBoolean("opendistro_security.audit.resolve_bulk_requests", Boolean.valueOf(false));
            boolean logRequestBody = settings.getAsBoolean("opendistro_security.audit.log_request_body", Boolean.valueOf(true));
            boolean resolveIndices = settings.getAsBoolean("opendistro_security.audit.resolve_indices", Boolean.valueOf(true));
            boolean excludeSensitiveHeaders = settings.getAsBoolean("opendistro_security.audit.exclude_sensitive_headers", Boolean.valueOf(true));
            Set<AuditCategory> disabledRestCategories = AuditCategory.from(settings, "opendistro_security.audit.config.disabled_rest_categories");
            Set<AuditCategory> disabledTransportCategories = AuditCategory.from(settings, "opendistro_security.audit.config.disabled_transport_categories");
            Set<String> ignoredAuditUsers = ConfigConstants.getSettingAsSet(settings, "opendistro_security.audit.ignore_users", DEFAULT_IGNORED_USERS, false);
            ImmutableSet ignoreAuditRequests = ImmutableSet.copyOf((Collection)settings.getAsList("opendistro_security.audit.ignore_requests", Collections.emptyList()));
            return new Filter(isRestApiAuditEnabled, isTransportAuditEnabled, resolveBulkRequests, logRequestBody, resolveIndices, excludeSensitiveHeaders, ignoredAuditUsers, (Set<String>)ignoreAuditRequests, disabledRestCategories, disabledTransportCategories);
        }

        @JsonProperty(value="enable_rest")
        public boolean isRestApiAuditEnabled() {
            return this.isRestApiAuditEnabled;
        }

        @JsonProperty(value="enable_transport")
        public boolean isTransportApiAuditEnabled() {
            return this.isTransportApiAuditEnabled;
        }

        @JsonProperty(value="resolve_bulk_requests")
        public boolean shouldResolveBulkRequests() {
            return this.resolveBulkRequests;
        }

        @JsonProperty(value="log_request_body")
        public boolean shouldLogRequestBody() {
            return this.logRequestBody;
        }

        @JsonProperty(value="resolve_indices")
        public boolean shouldResolveIndices() {
            return this.resolveIndices;
        }

        @JsonProperty(value="exclude_sensitive_headers")
        public boolean shouldExcludeSensitiveHeaders() {
            return this.excludeSensitiveHeaders;
        }

        @VisibleForTesting
        WildcardMatcher getIgnoredAuditUsersMatcher() {
            return this.ignoredAuditUsersMatcher;
        }

        public boolean isAuditDisabled(String user) {
            return this.ignoredAuditUsersMatcher.test(user);
        }

        @VisibleForTesting
        WildcardMatcher getIgnoredAuditRequestsMatcher() {
            return this.ignoredAuditRequestsMatcher;
        }

        public boolean isRequestAuditDisabled(String action) {
            return this.ignoredAuditRequestsMatcher.test(action);
        }

        @JsonProperty(value="disabled_rest_categories")
        public Set<AuditCategory> getDisabledRestCategories() {
            return this.disabledRestCategories;
        }

        @JsonProperty(value="disabled_transport_categories")
        public Set<AuditCategory> getDisabledTransportCategories() {
            return this.disabledTransportCategories;
        }

        public void log(Logger logger) {
            logger.info("Auditing on REST API is {}.", (Object)(this.isRestApiAuditEnabled ? "enabled" : "disabled"));
            logger.info("{} are excluded from REST API auditing.", this.disabledRestCategories);
            logger.info("Auditing on Transport API is {}.", (Object)(this.isTransportApiAuditEnabled ? "enabled" : "disabled"));
            logger.info("{} are excluded from Transport API auditing.", this.disabledTransportCategories);
            logger.info("Auditing of request body is {}.", (Object)(this.logRequestBody ? "enabled" : "disabled"));
            logger.info("Bulk requests resolution is {} during request auditing.", (Object)(this.resolveBulkRequests ? "enabled" : "disabled"));
            logger.info("Index resolution is {} during request auditing.", (Object)(this.resolveIndices ? "enabled" : "disabled"));
            logger.info("Sensitive headers auditing is {}.", (Object)(this.excludeSensitiveHeaders ? "enabled" : "disabled"));
            logger.info("Auditing requests from {} users is disabled.", (Object)this.ignoredAuditUsersMatcher);
        }

        public String toString() {
            return "Filter{isRestApiAuditEnabled=" + this.isRestApiAuditEnabled + ", disabledRestCategories=" + this.disabledRestCategories + ", isTransportApiAuditEnabled=" + this.isTransportApiAuditEnabled + ", disabledTransportCategories=" + this.disabledTransportCategories + ", resolveBulkRequests=" + this.resolveBulkRequests + ", logRequestBody=" + this.logRequestBody + ", resolveIndices=" + this.resolveIndices + ", excludeSensitiveHeaders=" + this.excludeSensitiveHeaders + ", ignoredAuditUsers=" + this.ignoredAuditUsersMatcher + ", ignoreAuditRequests=" + this.ignoredAuditRequestsMatcher + '}';
        }

        static /* synthetic */ Set access$000() {
            return FIELDS;
        }
    }
}

