/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.security.action.configupdate;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ConfigUpdateNodeResponse
extends BaseNodeResponse {
    private String[] updatedConfigTypes;
    private String message;

    public ConfigUpdateNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.updatedConfigTypes = in.readStringArray();
        this.message = in.readOptionalString();
    }

    public ConfigUpdateNodeResponse(DiscoveryNode node, String[] updatedConfigTypes, String message) {
        super(node);
        this.updatedConfigTypes = updatedConfigTypes;
        this.message = message;
    }

    public static ConfigUpdateNodeResponse readNodeResponse(StreamInput in) throws IOException {
        return new ConfigUpdateNodeResponse(in);
    }

    public String[] getUpdatedConfigTypes() {
        return this.updatedConfigTypes == null ? null : Arrays.copyOf(this.updatedConfigTypes, this.updatedConfigTypes.length);
    }

    public String getMessage() {
        return this.message;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.updatedConfigTypes);
        out.writeOptionalString(this.message);
    }

    public String toString() {
        return "ConfigUpdateNodeResponse [updatedConfigTypes=" + Arrays.toString(this.updatedConfigTypes) + ", message=" + this.message + "]";
    }
}

