/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.ldap2;

import com.amazon.dlic.auth.ldap.LdapUser;
import com.amazon.dlic.auth.ldap.util.Utils;
import com.amazon.dlic.auth.ldap2.LDAPConnectionFactoryFactory;
import com.amazon.dlic.auth.ldap2.LDAPUserSearcher;
import com.amazon.dlic.util.SettingsBasedSSLConfigurator;
import com.amazon.opendistroforelasticsearch.security.auth.AuthenticationBackend;
import com.amazon.opendistroforelasticsearch.security.auth.Destroyable;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.user.AuthCredentials;
import com.amazon.opendistroforelasticsearch.security.user.User;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Settings;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.pool.ConnectionPool;

public class LDAPAuthenticationBackend2
implements AuthenticationBackend,
Destroyable {
    protected static final Logger log = LogManager.getLogger(LDAPAuthenticationBackend2.class);
    private final Settings settings;
    private ConnectionPool connectionPool;
    private ConnectionFactory connectionFactory;
    private ConnectionFactory authConnectionFactory;
    private LDAPUserSearcher userSearcher;
    private final int customAttrMaxValueLen;
    private final WildcardMatcher whitelistedCustomLdapAttrMatcher;

    public LDAPAuthenticationBackend2(Settings settings, Path configPath) throws SettingsBasedSSLConfigurator.SSLConfigException {
        this.settings = settings;
        LDAPConnectionFactoryFactory ldapConnectionFactoryFactory = new LDAPConnectionFactoryFactory(settings, configPath);
        this.connectionPool = ldapConnectionFactoryFactory.createConnectionPool();
        this.connectionFactory = ldapConnectionFactoryFactory.createConnectionFactory(this.connectionPool);
        this.authConnectionFactory = this.connectionPool != null ? ldapConnectionFactoryFactory.createBasicConnectionFactory() : this.connectionFactory;
        this.userSearcher = new LDAPUserSearcher(settings);
        this.customAttrMaxValueLen = settings.getAsInt("custom_attr_maxval_len", Integer.valueOf(36));
        this.whitelistedCustomLdapAttrMatcher = WildcardMatcher.from(settings.getAsList("custom_attr_whitelist", Collections.singletonList("*")));
    }

    @Override
    public User authenticate(final AuthCredentials credentials) throws ElasticsearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<User>(){

                @Override
                public User run() throws Exception {
                    return LDAPAuthenticationBackend2.this.authenticate0(credentials);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ElasticsearchSecurityException) {
                throw (ElasticsearchSecurityException)e.getException();
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e.getException());
        }
    }

    private User authenticate0(AuthCredentials credentials) throws ElasticsearchSecurityException {
        Connection ldapConnection = null;
        String user = credentials.getUsername();
        byte[] password = credentials.getPassword();
        try {
            ldapConnection = this.connectionFactory.getConnection();
            ldapConnection.open();
            LdapEntry entry = this.userSearcher.exists(ldapConnection, user);
            if (entry == null && this.settings.getAsBoolean("fakelogin_enabled", Boolean.valueOf(false)).booleanValue()) {
                String fakeLognDn = this.settings.get("fakelogin_dn", "CN=faketomakebindfail,DC=" + UUID.randomUUID().toString());
                entry = new LdapEntry(fakeLognDn);
                password = this.settings.get("fakelogin_password", "fakeLoginPwd123").getBytes(StandardCharsets.UTF_8);
            } else if (entry == null) {
                throw new ElasticsearchSecurityException("No user " + user + " found", new Object[0]);
            }
            String dn = entry.getDn();
            if (log.isTraceEnabled()) {
                log.trace("Try to authenticate dn {}", (Object)dn);
            }
            if (this.connectionPool == null) {
                this.authenticateByLdapServer(ldapConnection, dn, password);
            } else {
                this.authenticateByLdapServerWithSeparateConnection(dn, password);
            }
            String usernameAttribute = this.settings.get("username_attribute", null);
            String username = dn;
            if (usernameAttribute != null && entry.getAttribute(usernameAttribute) != null) {
                username = Utils.getSingleStringValue(entry.getAttribute(usernameAttribute));
            }
            if (log.isDebugEnabled()) {
                log.debug("Authenticated username {}", (Object)username);
            }
            LdapUser ldapUser = new LdapUser(username, user, entry, credentials, this.customAttrMaxValueLen, this.whitelistedCustomLdapAttrMatcher);
            return ldapUser;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to authenticate user due to ", (Throwable)e);
            }
            throw new ElasticsearchSecurityException(e.toString(), e, new Object[0]);
        }
        finally {
            Arrays.fill(password, (byte)0);
            password = null;
            Utils.unbindAndCloseSilently(ldapConnection);
        }
    }

    @Override
    public String getType() {
        return "ldap";
    }

    @Override
    public boolean exists(final User user) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return LDAPAuthenticationBackend2.this.exists0(user);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists0(User user) {
        Connection ldapConnection = null;
        String userName = user.getName();
        if (user instanceof LdapUser) {
            userName = ((LdapUser)user).getUserEntry().getDn();
        }
        try {
            boolean exists;
            ldapConnection = this.connectionFactory.getConnection();
            ldapConnection.open();
            LdapEntry userEntry = this.userSearcher.exists(ldapConnection, userName);
            boolean bl = exists = userEntry != null;
            if (exists) {
                user.addAttributes(LdapUser.extractLdapAttributes(userName, userEntry, this.customAttrMaxValueLen, this.whitelistedCustomLdapAttrMatcher));
            }
            boolean bl2 = exists;
            return bl2;
        }
        catch (Exception e) {
            log.warn("User {} does not exist due to " + e, (Object)userName);
            if (log.isDebugEnabled()) {
                log.debug("User does not exist due to ", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.unbindAndCloseSilently(ldapConnection);
        }
    }

    private void authenticateByLdapServer(final Connection connection, final String dn, final byte[] password) throws LdapException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Response<Void>>(){

                @Override
                public Response<Void> run() throws LdapException {
                    return connection.getProviderConnection().bind(new BindRequest(dn, new Credential(password)));
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof LdapException) {
                throw (LdapException)e.getException();
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e);
        }
    }

    private void authenticateByLdapServerWithSeparateConnection(String dn, byte[] password) throws LdapException {
        try (Connection unpooledConnection = this.authConnectionFactory.getConnection();){
            unpooledConnection.open();
            this.authenticateByLdapServer(unpooledConnection, dn, password);
        }
    }

    @Override
    public void destroy() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
            this.connectionPool = null;
        }
    }
}

