/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.ldap;

import com.amazon.dlic.auth.ldap.util.Utils;
import com.amazon.opendistroforelasticsearch.security.support.WildcardMatcher;
import com.amazon.opendistroforelasticsearch.security.user.AuthCredentials;
import com.amazon.opendistroforelasticsearch.security.user.User;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;

public class LdapUser
extends User {
    private static final long serialVersionUID = 1L;
    private final transient LdapEntry userEntry;
    private final String originalUsername;

    public LdapUser(String name, String originalUsername, LdapEntry userEntry, AuthCredentials credentials, int customAttrMaxValueLen, WildcardMatcher whitelistedCustomLdapAttrMatcher) {
        super(name, null, credentials);
        this.originalUsername = originalUsername;
        this.userEntry = userEntry;
        Map<String, String> attributes = this.getCustomAttributesMap();
        attributes.putAll(LdapUser.extractLdapAttributes(originalUsername, userEntry, customAttrMaxValueLen, whitelistedCustomLdapAttrMatcher));
    }

    public LdapEntry getUserEntry() {
        return this.userEntry;
    }

    public String getDn() {
        return this.userEntry.getDn();
    }

    public String getOriginalUsername() {
        return this.originalUsername;
    }

    public static Map<String, String> extractLdapAttributes(String originalUsername, LdapEntry userEntry, int customAttrMaxValueLen, WildcardMatcher whitelistedCustomLdapAttrMatcher) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ldap.original.username", originalUsername);
        attributes.put("ldap.dn", userEntry.getDn());
        if (customAttrMaxValueLen > 0) {
            for (LdapAttribute attr : userEntry.getAttributes()) {
                String val;
                if (attr == null || attr.isBinary() || attr.getName().toLowerCase().contains("password") || (val = Utils.getSingleStringValue(attr)) == null || val.length() <= 0 || val.length() > customAttrMaxValueLen || !whitelistedCustomLdapAttrMatcher.test(attr.getName())) continue;
                attributes.put("attr.ldap." + attr.getName(), val);
            }
        }
        return Collections.unmodifiableMap(attributes);
    }
}

