/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.saml;

import com.amazon.dlic.auth.http.jwt.keybyoidc.AuthenticatorUnavailableException;
import com.amazon.dlic.auth.http.saml.SamlConfigException;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import java.security.AccessController;
import java.security.PrivateKey;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Settings;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;

public class Saml2SettingsProvider {
    protected static final Logger log = LogManager.getLogger(Saml2SettingsProvider.class);
    private final Settings esSettings;
    private final MetadataResolver metadataResolver;
    private final String idpEntityId;
    private final PrivateKey spSignaturePrivateKey;
    private Saml2Settings cachedSaml2Settings;
    private DateTime metadataUpdateTime;

    Saml2SettingsProvider(Settings esSettings, MetadataResolver metadataResolver, PrivateKey spSignaturePrivateKey) {
        this.esSettings = esSettings;
        this.metadataResolver = metadataResolver;
        this.idpEntityId = esSettings.get("idp.entity_id");
        this.spSignaturePrivateKey = spSignaturePrivateKey;
    }

    Saml2Settings get() throws SamlConfigException {
        try {
            HashMap<String, Object> configProperties = new HashMap<String, Object>();
            EntityDescriptor entityDescriptor = (EntityDescriptor)this.metadataResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.idpEntityId)}));
            if (entityDescriptor == null) {
                throw new SamlConfigException("Could not find entity descriptor for " + this.idpEntityId);
            }
            IDPSSODescriptor idpSsoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
            if (idpSsoDescriptor == null) {
                throw new SamlConfigException("Could not find IDPSSODescriptor supporting SAML 2.0 in " + this.idpEntityId + "; role descriptors: " + entityDescriptor.getRoleDescriptors());
            }
            this.initIdpEndpoints(idpSsoDescriptor, configProperties);
            this.initIdpCerts(idpSsoDescriptor, configProperties);
            this.initSpEndpoints(configProperties);
            this.initMisc(configProperties);
            SettingsBuilder settingsBuilder = new SettingsBuilder();
            settingsBuilder.fromValues(configProperties);
            settingsBuilder.fromValues((Map)new SamlSettingsMap(this.esSettings));
            SpecialPermission.check();
            return AccessController.doPrivileged(() -> settingsBuilder.build());
        }
        catch (ResolverException e) {
            throw new AuthenticatorUnavailableException(e);
        }
    }

    Saml2Settings getCached() throws SamlConfigException {
        DateTime tempLastUpdate = null;
        if (this.metadataResolver instanceof RefreshableMetadataResolver && this.isUpdateRequired()) {
            this.cachedSaml2Settings = null;
            tempLastUpdate = ((RefreshableMetadataResolver)this.metadataResolver).getLastUpdate();
        }
        if (this.cachedSaml2Settings == null) {
            this.cachedSaml2Settings = this.get();
            this.metadataUpdateTime = tempLastUpdate;
        }
        return this.cachedSaml2Settings;
    }

    private boolean isUpdateRequired() {
        RefreshableMetadataResolver refreshableMetadataResolver = (RefreshableMetadataResolver)this.metadataResolver;
        if (this.cachedSaml2Settings == null || this.metadataUpdateTime == null || refreshableMetadataResolver.getLastUpdate() == null) {
            return true;
        }
        return refreshableMetadataResolver.getLastUpdate().isAfter((ReadableInstant)this.metadataUpdateTime);
    }

    private void initMisc(HashMap<String, Object> configProperties) {
        configProperties.put("onelogin.saml2.strict", true);
        configProperties.put("onelogin.saml2.security.reject_unsolicited_responses_with_inresponseto", true);
        configProperties.put("onelogin.saml2.sp.privatekey", this.spSignaturePrivateKey);
    }

    private void initSpEndpoints(HashMap<String, Object> configProperties) {
        configProperties.put("onelogin.saml2.sp.assertion_consumer_service.url", this.buildKibanaAssertionConsumerEndpoint(this.esSettings.get("kibana_url")));
        configProperties.put("onelogin.saml2.sp.assertion_consumer_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        configProperties.put("onelogin.saml2.sp.entityid", this.esSettings.get("sp.entity_id"));
    }

    private void initIdpEndpoints(IDPSSODescriptor idpSsoDescriptor, HashMap<String, Object> configProperties) throws SamlConfigException {
        SingleSignOnService singleSignOnService = this.findSingleSignOnService(idpSsoDescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        configProperties.put("onelogin.saml2.idp.single_sign_on_service.url", singleSignOnService.getLocation());
        configProperties.put("onelogin.saml2.idp.single_sign_on_service.binding", singleSignOnService.getBinding());
        configProperties.put("onelogin.saml2.idp.entityid", this.esSettings.get("idp.entity_id"));
        SingleLogoutService singleLogoutService = this.findSingleLogoutService(idpSsoDescriptor, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        if (singleLogoutService != null) {
            configProperties.put("onelogin.saml2.idp.single_logout_service.url", singleLogoutService.getLocation());
            configProperties.put("onelogin.saml2.idp.single_logout_service.binding", singleLogoutService.getBinding());
        } else {
            log.warn("The IdP does not provide a Single Logout Service. In order to ensure that users have to re-enter their password after logging out, Open Distro Security will issue all SAML authentication requests with a mandatory password input (ForceAuthn=true)");
        }
    }

    private void initIdpCerts(IDPSSODescriptor idpSsoDescriptor, HashMap<String, Object> configProperties) {
        int i = 0;
        for (KeyDescriptor keyDescriptor : idpSsoDescriptor.getKeyDescriptors()) {
            if (!UsageType.SIGNING.equals((Object)keyDescriptor.getUse()) && !UsageType.UNSPECIFIED.equals((Object)keyDescriptor.getUse())) continue;
            for (X509Data x509data : keyDescriptor.getKeyInfo().getX509Datas()) {
                for (X509Certificate x509Certificate : x509data.getX509Certificates()) {
                    configProperties.put("onelogin.saml2.idp.x509certMulti." + i++, x509Certificate.getValue());
                }
            }
        }
    }

    private SingleSignOnService findSingleSignOnService(IDPSSODescriptor idpSsoDescriptor, String binding) throws SamlConfigException {
        for (SingleSignOnService singleSignOnService : idpSsoDescriptor.getSingleSignOnServices()) {
            if (!binding.equals(singleSignOnService.getBinding())) continue;
            return singleSignOnService;
        }
        throw new SamlConfigException("Could not find SingleSignOnService endpoint for binding " + binding + "; available services: " + idpSsoDescriptor.getSingleSignOnServices());
    }

    private SingleLogoutService findSingleLogoutService(IDPSSODescriptor idpSsoDescriptor, String binding) throws SamlConfigException {
        for (SingleLogoutService singleLogoutService : idpSsoDescriptor.getSingleLogoutServices()) {
            if (!binding.equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService;
        }
        return null;
    }

    private String buildKibanaAssertionConsumerEndpoint(String kibanaRoot) {
        if (kibanaRoot.endsWith("/")) {
            return kibanaRoot + "_opendistro/_security/saml/acs";
        }
        return kibanaRoot + "/_opendistro/_security/saml/acs";
    }

    static class SamlSettingsMap
    implements Map<String, Object> {
        private static final String KEY_PREFIX = "onelogin.saml2.";
        private Settings settings;

        SamlSettingsMap(Settings settings) {
            this.settings = settings.getAsSettings("validator");
        }

        @Override
        public int size() {
            return this.settings.size();
        }

        @Override
        public boolean isEmpty() {
            return this.settings.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.settings.hasValue(this.adaptKey(key));
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return this.settings.get(this.adaptKey(key));
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            return this.settings.keySet().stream().map(s -> KEY_PREFIX + s).collect(Collectors.toSet());
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
            for (String key : this.settings.keySet()) {
                result.add(new AbstractMap.SimpleEntry<String, String>(KEY_PREFIX + key, this.settings.get(key)));
            }
            return result;
        }

        private String adaptKey(Object keyObject) {
            if (keyObject == null) {
                return null;
            }
            String key = String.valueOf(keyObject);
            if (key.startsWith(KEY_PREFIX)) {
                return key.substring(KEY_PREFIX.length());
            }
            return key;
        }
    }
}

