/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.protocol.response.format;

import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.ErrorFormatter;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.ResponseFormatter;
import java.security.AccessController;
import lombok.Generated;

public abstract class JsonResponseFormatter<R>
implements ResponseFormatter<R> {
    private final Style style;

    @Override
    public String format(R response) {
        return this.jsonify(this.buildJsonObject(response));
    }

    @Override
    public String format(Throwable t) {
        return AccessController.doPrivileged(() -> this.style == Style.PRETTY ? ErrorFormatter.prettyFormat(t) : ErrorFormatter.compactFormat(t));
    }

    protected abstract Object buildJsonObject(R var1);

    protected String jsonify(Object jsonObject) {
        return AccessController.doPrivileged(() -> this.style == Style.PRETTY ? ErrorFormatter.prettyJsonify(jsonObject) : ErrorFormatter.compactJsonify(jsonObject));
    }

    @Generated
    public JsonResponseFormatter(Style style) {
        this.style = style;
    }

    public static enum Style {
        PRETTY,
        COMPACT;

    }
}

