/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.protocol.response.format;

import com.amazon.opendistroforelasticsearch.sql.protocol.response.QueryResult;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.ErrorFormatter;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.ResponseFormatter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class CsvResponseFormatter
implements ResponseFormatter<QueryResult> {
    private static final String INLINE_SEPARATOR = ",";
    private static final String INTERLINE_SEPARATOR = System.lineSeparator();
    private static final Set<String> SENSITIVE_CHAR = ImmutableSet.of((Object)"=", (Object)"+", (Object)"-", (Object)"@");
    private final boolean sanitize;

    public CsvResponseFormatter() {
        this.sanitize = true;
    }

    @Override
    public String format(QueryResult response) {
        CsvResult result = new CsvResult(response, this.sanitize);
        return result.getCsv();
    }

    @Override
    public String format(Throwable t) {
        return ErrorFormatter.prettyFormat(t);
    }

    @Generated
    public CsvResponseFormatter(boolean sanitize) {
        this.sanitize = sanitize;
    }

    static class CsvResult {
        private final QueryResult response;
        private final boolean sanitize;

        public String getCsv() {
            ArrayList<String> headersAndData = new ArrayList<String>();
            headersAndData.add(this.getHeaderLine(this.response, this.sanitize));
            headersAndData.addAll(this.getDataLines(this.response, this.sanitize));
            return String.join((CharSequence)INTERLINE_SEPARATOR, headersAndData);
        }

        private String getHeaderLine(QueryResult response, boolean sanitize) {
            List<String> headers = this.getHeaders(response, sanitize);
            return String.join((CharSequence)CsvResponseFormatter.INLINE_SEPARATOR, headers);
        }

        private List<String> getDataLines(QueryResult response, boolean sanitize) {
            List<List<String>> data = this.getData(response, sanitize);
            return data.stream().map(v -> String.join((CharSequence)CsvResponseFormatter.INLINE_SEPARATOR, v)).collect(Collectors.toList());
        }

        private List<String> getHeaders(QueryResult response, boolean sanitize) {
            ImmutableList.Builder headers = ImmutableList.builder();
            response.columnNameTypes().forEach((column, type) -> headers.add(column));
            ImmutableList result = headers.build();
            return sanitize ? this.sanitizeHeaders((List<String>)result) : result;
        }

        private List<List<String>> getData(QueryResult response, boolean sanitize) {
            ImmutableList.Builder dataLines = new ImmutableList.Builder();
            response.iterator().forEachRemaining(row -> {
                ImmutableList.Builder line = new ImmutableList.Builder();
                Arrays.asList(row).forEach(val -> line.add((Object)(val == null ? "" : val.toString())));
                dataLines.add((Object)line.build());
            });
            ImmutableList result = dataLines.build();
            return sanitize ? this.sanitizeData((List<List<String>>)result) : result;
        }

        private List<String> sanitizeHeaders(List<String> headers) {
            return headers.stream().map(this::sanitizeCell).map(cell -> this.quoteIfRequired(CsvResponseFormatter.INLINE_SEPARATOR, (String)cell)).collect(Collectors.toList());
        }

        private List<List<String>> sanitizeData(List<List<String>> lines) {
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            for (List<String> line : lines) {
                result.add(line.stream().map(this::sanitizeCell).map(cell -> this.quoteIfRequired(CsvResponseFormatter.INLINE_SEPARATOR, (String)cell)).collect(Collectors.toList()));
            }
            return result;
        }

        private String sanitizeCell(String cell) {
            if (this.isStartWithSensitiveChar(cell)) {
                return "'" + cell;
            }
            return cell;
        }

        private String quoteIfRequired(String separator, String cell) {
            String quote = "\"";
            return cell.contains(separator) ? "\"" + cell.replaceAll("\"", "\"\"") + "\"" : cell;
        }

        private boolean isStartWithSensitiveChar(String cell) {
            return SENSITIVE_CHAR.stream().anyMatch(cell::startsWith);
        }

        @Generated
        public QueryResult getResponse() {
            return this.response;
        }

        @Generated
        public boolean isSanitize() {
            return this.sanitize;
        }

        @Generated
        public CsvResult(QueryResult response, boolean sanitize) {
            this.response = response;
            this.sanitize = sanitize;
        }
    }
}

