/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.protocol.response;

import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValue;
import com.amazon.opendistroforelasticsearch.sql.data.model.ExprValueUtils;
import com.amazon.opendistroforelasticsearch.sql.executor.ExecutionEngine;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public class QueryResult
implements Iterable<Object[]> {
    private final ExecutionEngine.Schema schema;
    private final Collection<ExprValue> exprValues;

    public int size() {
        return this.exprValues.size();
    }

    public Map<String, String> columnNameTypes() {
        LinkedHashMap<String, String> colNameTypes = new LinkedHashMap<String, String>();
        this.schema.getColumns().forEach(column -> colNameTypes.put(this.getColumnName((ExecutionEngine.Schema.Column)column), column.getExprType().typeName().toLowerCase()));
        return colNameTypes;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return this.exprValues.stream().map(ExprValueUtils::getTupleValue).map(Map::values).map(this::convertExprValuesToValues).iterator();
    }

    private String getColumnName(ExecutionEngine.Schema.Column column) {
        return column.getAlias() != null ? column.getAlias() : column.getName();
    }

    private Object[] convertExprValuesToValues(Collection<ExprValue> exprValues) {
        return exprValues.stream().map(ExprValue::value).toArray(Object[]::new);
    }

    @Generated
    public QueryResult(ExecutionEngine.Schema schema, Collection<ExprValue> exprValues) {
        this.schema = schema;
        this.exprValues = exprValues;
    }

    @Generated
    public ExecutionEngine.Schema getSchema() {
        return this.schema;
    }
}

