/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.ppl.utils;

import com.amazon.opendistroforelasticsearch.sql.ast.AbstractNodeVisitor;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.AggregateFunction;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Alias;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.And;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Argument;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Compare;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Field;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Function;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Interval;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Let;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Literal;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Map;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Not;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Or;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Xor;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Aggregation;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Dedupe;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Eval;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Filter;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Head;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Project;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.RareTopN;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Relation;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Rename;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Sort;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.UnresolvedPlan;
import com.amazon.opendistroforelasticsearch.sql.common.utils.StringUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PPLQueryDataAnonymizer
extends AbstractNodeVisitor<String, String> {
    private static final String MASK_LITERAL = "***";
    private final AnonymizerExpressionAnalyzer expressionAnalyzer = new AnonymizerExpressionAnalyzer();

    public String anonymizeData(UnresolvedPlan plan) {
        return (String)plan.accept((AbstractNodeVisitor)this, null);
    }

    public String visitRelation(Relation node, String context) {
        return StringUtils.format((String)"source=%s", (Object[])new Object[]{node.getTableName()});
    }

    public String visitFilter(Filter node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String condition = this.visitExpression(node.getCondition());
        return StringUtils.format((String)"%s | where %s", (Object[])new Object[]{child, condition});
    }

    public String visitRename(Rename node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        ImmutableMap.Builder renameMapBuilder = new ImmutableMap.Builder();
        for (Map renameMap : node.getRenameList()) {
            renameMapBuilder.put((Object)this.visitExpression(renameMap.getOrigin()), (Object)((Field)renameMap.getTarget()).getField().toString());
        }
        String renames = renameMapBuilder.build().entrySet().stream().map(entry -> StringUtils.format((String)"%s as %s", (Object[])new Object[]{entry.getKey(), entry.getValue()})).collect(Collectors.joining(","));
        return StringUtils.format((String)"%s | rename %s", (Object[])new Object[]{child, renames});
    }

    public String visitAggregation(Aggregation node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String group = this.visitExpressionList(node.getGroupExprList());
        return StringUtils.format((String)"%s | stats %s", (Object[])new Object[]{child, String.join((CharSequence)" ", this.visitExpressionList(node.getAggExprList()), this.groupBy(group)).trim()});
    }

    public String visitRareTopN(RareTopN node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        List options = node.getNoOfResults();
        Integer noOfResults = (Integer)((Argument)options.get(0)).getValue().getValue();
        String fields = this.visitFieldList(node.getFields());
        String group = this.visitExpressionList(node.getGroupExprList());
        return StringUtils.format((String)"%s | %s %d %s", (Object[])new Object[]{child, node.getCommandType().name().toLowerCase(), noOfResults, String.join((CharSequence)" ", fields, this.groupBy(group)).trim()});
    }

    public String visitProject(Project node, String context) {
        Argument argument;
        Boolean exclude;
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String arg = "+";
        String fields = this.visitExpressionList(node.getProjectList());
        if (node.hasArgument() && (exclude = (Boolean)(argument = (Argument)node.getArgExprList().get(0)).getValue().getValue()).booleanValue()) {
            arg = "-";
        }
        return StringUtils.format((String)"%s | fields %s %s", (Object[])new Object[]{child, arg, fields});
    }

    public String visitEval(Eval node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        ImmutableList.Builder expressionsBuilder = new ImmutableList.Builder();
        for (Let let : node.getExpressionList()) {
            String expression = this.visitExpression(let.getExpression());
            String target = let.getVar().getField().toString();
            expressionsBuilder.add((Object)ImmutablePair.of((Object)target, (Object)expression));
        }
        String expressions = expressionsBuilder.build().stream().map(pair -> StringUtils.format((String)"%s=%s", (Object[])new Object[]{pair.getLeft(), pair.getRight()})).collect(Collectors.joining(" "));
        return StringUtils.format((String)"%s | eval %s", (Object[])new Object[]{child, expressions});
    }

    public String visitSort(Sort node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String sortList = this.visitFieldList(node.getSortList());
        return StringUtils.format((String)"%s | sort %s", (Object[])new Object[]{child, sortList});
    }

    public String visitDedupe(Dedupe node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String fields = this.visitFieldList(node.getFields());
        List options = node.getOptions();
        Integer allowedDuplication = (Integer)((Argument)options.get(0)).getValue().getValue();
        Boolean keepEmpty = (Boolean)((Argument)options.get(1)).getValue().getValue();
        Boolean consecutive = (Boolean)((Argument)options.get(2)).getValue().getValue();
        return StringUtils.format((String)"%s | dedup %s %d keepempty=%b consecutive=%b", (Object[])new Object[]{child, fields, allowedDuplication, keepEmpty, consecutive});
    }

    public String visitHead(Head node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        Integer size = node.getSize();
        return StringUtils.format((String)"%s | head %d", (Object[])new Object[]{child, size});
    }

    private String visitFieldList(List<Field> fieldList) {
        return fieldList.stream().map(this::visitExpression).collect(Collectors.joining(","));
    }

    private String visitExpressionList(List<UnresolvedExpression> expressionList) {
        return expressionList.isEmpty() ? "" : expressionList.stream().map(this::visitExpression).collect(Collectors.joining(","));
    }

    private String visitExpression(UnresolvedExpression expression) {
        return this.expressionAnalyzer.analyze(expression, null);
    }

    private String groupBy(String groupBy) {
        return Strings.isNullOrEmpty((String)groupBy) ? "" : StringUtils.format((String)"by %s", (Object[])new Object[]{groupBy});
    }

    private static class AnonymizerExpressionAnalyzer
    extends AbstractNodeVisitor<String, String> {
        private AnonymizerExpressionAnalyzer() {
        }

        public String analyze(UnresolvedExpression unresolved, String context) {
            return (String)unresolved.accept((AbstractNodeVisitor)this, (Object)context);
        }

        public String visitLiteral(Literal node, String context) {
            return PPLQueryDataAnonymizer.MASK_LITERAL;
        }

        public String visitInterval(Interval node, String context) {
            String value = (String)node.getValue().accept((AbstractNodeVisitor)this, (Object)context);
            String unit = node.getUnit().name();
            return StringUtils.format((String)"INTERVAL %s %s", (Object[])new Object[]{value, unit});
        }

        public String visitAnd(And node, String context) {
            String left = (String)node.getLeft().accept((AbstractNodeVisitor)this, (Object)context);
            String right = (String)node.getRight().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s and %s", (Object[])new Object[]{left, right});
        }

        public String visitOr(Or node, String context) {
            String left = (String)node.getLeft().accept((AbstractNodeVisitor)this, (Object)context);
            String right = (String)node.getRight().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s or %s", (Object[])new Object[]{left, right});
        }

        public String visitXor(Xor node, String context) {
            String left = (String)node.getLeft().accept((AbstractNodeVisitor)this, (Object)context);
            String right = (String)node.getRight().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s xor %s", (Object[])new Object[]{left, right});
        }

        public String visitNot(Not node, String context) {
            String expr = (String)node.getExpression().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"not %s", (Object[])new Object[]{expr});
        }

        public String visitAggregateFunction(AggregateFunction node, String context) {
            String arg = (String)node.getField().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{node.getFuncName(), arg});
        }

        public String visitFunction(Function node, String context) {
            String arguments = node.getFuncArgs().stream().map(unresolvedExpression -> this.analyze((UnresolvedExpression)unresolvedExpression, context)).collect(Collectors.joining(","));
            return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{node.getFuncName(), arguments});
        }

        public String visitCompare(Compare node, String context) {
            String left = this.analyze(node.getLeft(), context);
            String right = this.analyze(node.getRight(), context);
            return StringUtils.format((String)"%s %s %s", (Object[])new Object[]{left, node.getOperator(), right});
        }

        public String visitField(Field node, String context) {
            return node.getField().toString();
        }

        public String visitAlias(Alias node, String context) {
            String expr = (String)node.getDelegated().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s", (Object[])new Object[]{expr});
        }
    }
}

