/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.ppl.parser;

import com.amazon.opendistroforelasticsearch.sql.ast.dsl.AstDSL;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.AggregateFunction;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.AllFields;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.And;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Argument;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Compare;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.DataType;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Field;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Function;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.In;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Interval;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.IntervalUnit;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Let;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Literal;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Not;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Or;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.QualifiedName;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Xor;
import com.amazon.opendistroforelasticsearch.sql.common.utils.StringUtils;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionName;
import com.amazon.opendistroforelasticsearch.sql.ppl.antlr.parser.OpenDistroPPLParser;
import com.amazon.opendistroforelasticsearch.sql.ppl.antlr.parser.OpenDistroPPLParserBaseVisitor;
import com.amazon.opendistroforelasticsearch.sql.ppl.utils.ArgumentFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class AstExpressionBuilder
extends OpenDistroPPLParserBaseVisitor<UnresolvedExpression> {
    private static Map<String, String> FUNCTION_NAME_MAPPING = new ImmutableMap.Builder().put((Object)"isnull", (Object)BuiltinFunctionName.IS_NULL.getName().getFunctionName()).put((Object)"isnotnull", (Object)BuiltinFunctionName.IS_NOT_NULL.getName().getFunctionName()).build();

    @Override
    public UnresolvedExpression visitEvalClause(OpenDistroPPLParser.EvalClauseContext ctx) {
        return new Let((Field)this.visit((ParseTree)ctx.fieldExpression()), (UnresolvedExpression)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public UnresolvedExpression visitLogicalNot(OpenDistroPPLParser.LogicalNotContext ctx) {
        return new Not((UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression()));
    }

    @Override
    public UnresolvedExpression visitLogicalOr(OpenDistroPPLParser.LogicalOrContext ctx) {
        return new Or((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLogicalAnd(OpenDistroPPLParser.LogicalAndContext ctx) {
        return new And((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLogicalXor(OpenDistroPPLParser.LogicalXorContext ctx) {
        return new Xor((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitCompareExpr(OpenDistroPPLParser.CompareExprContext ctx) {
        return new Compare(ctx.comparisonOperator().getText(), (UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitInExpr(OpenDistroPPLParser.InExprContext ctx) {
        return new In((UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), ctx.valueList().literalValue().stream().map(this::visitLiteralValue).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitBinaryArithmetic(OpenDistroPPLParser.BinaryArithmeticContext ctx) {
        return new Function(ctx.binaryOperator().getText(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitParentheticBinaryArithmetic(OpenDistroPPLParser.ParentheticBinaryArithmeticContext ctx) {
        return new Function(ctx.binaryOperator().getText(), Arrays.asList((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right)));
    }

    @Override
    public UnresolvedExpression visitFieldExpression(OpenDistroPPLParser.FieldExpressionContext ctx) {
        return new Field((UnresolvedExpression)((QualifiedName)this.visit((ParseTree)ctx.qualifiedName())));
    }

    @Override
    public UnresolvedExpression visitWcFieldExpression(OpenDistroPPLParser.WcFieldExpressionContext ctx) {
        return new Field((UnresolvedExpression)((QualifiedName)this.visit((ParseTree)ctx.wcQualifiedName())));
    }

    @Override
    public UnresolvedExpression visitSortField(OpenDistroPPLParser.SortFieldContext ctx) {
        return new Field((UnresolvedExpression)AstDSL.qualifiedName((String[])new String[]{ctx.sortFieldExpression().fieldExpression().getText()}), ArgumentFactory.getArgumentList(ctx));
    }

    @Override
    public UnresolvedExpression visitStatsFunctionCall(OpenDistroPPLParser.StatsFunctionCallContext ctx) {
        return new AggregateFunction(ctx.statsFunctionName().getText(), (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()));
    }

    @Override
    public UnresolvedExpression visitCountAllFunctionCall(OpenDistroPPLParser.CountAllFunctionCallContext ctx) {
        return new AggregateFunction("count", (UnresolvedExpression)AllFields.of());
    }

    @Override
    public UnresolvedExpression visitPercentileAggFunction(OpenDistroPPLParser.PercentileAggFunctionContext ctx) {
        return new AggregateFunction(ctx.PERCENTILE().getText(), (UnresolvedExpression)this.visit((ParseTree)ctx.aggField), Collections.singletonList(new Argument("rank", (Literal)this.visit((ParseTree)ctx.value))));
    }

    @Override
    public UnresolvedExpression visitBooleanFunctionCall(OpenDistroPPLParser.BooleanFunctionCallContext ctx) {
        String functionName = ctx.conditionFunctionBase().getText();
        return new Function(FUNCTION_NAME_MAPPING.getOrDefault(functionName, functionName), ctx.functionArgs().functionArg().stream().map(this::visitFunctionArg).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitEvalFunctionCall(OpenDistroPPLParser.EvalFunctionCallContext ctx) {
        return new Function(ctx.evalFunctionName().getText(), ctx.functionArgs().functionArg().stream().map(this::visitFunctionArg).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitTableSource(OpenDistroPPLParser.TableSourceContext ctx) {
        return this.visitIdentifiers(Arrays.asList(ctx));
    }

    @Override
    public UnresolvedExpression visitIdentsAsQualifiedName(OpenDistroPPLParser.IdentsAsQualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.ident());
    }

    @Override
    public UnresolvedExpression visitIdentsAsWildcardQualifiedName(OpenDistroPPLParser.IdentsAsWildcardQualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.wildcard());
    }

    @Override
    public UnresolvedExpression visitIntervalLiteral(OpenDistroPPLParser.IntervalLiteralContext ctx) {
        return new Interval((UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), IntervalUnit.of((String)ctx.intervalUnit().getText()));
    }

    @Override
    public UnresolvedExpression visitStringLiteral(OpenDistroPPLParser.StringLiteralContext ctx) {
        return new Literal((Object)StringUtils.unquoteText((String)ctx.getText()), DataType.STRING);
    }

    @Override
    public UnresolvedExpression visitIntegerLiteral(OpenDistroPPLParser.IntegerLiteralContext ctx) {
        return new Literal((Object)Integer.valueOf(ctx.getText()), DataType.INTEGER);
    }

    @Override
    public UnresolvedExpression visitDecimalLiteral(OpenDistroPPLParser.DecimalLiteralContext ctx) {
        return new Literal((Object)Double.valueOf(ctx.getText()), DataType.DOUBLE);
    }

    @Override
    public UnresolvedExpression visitBooleanLiteral(OpenDistroPPLParser.BooleanLiteralContext ctx) {
        return new Literal((Object)Boolean.valueOf(ctx.getText()), DataType.BOOLEAN);
    }

    private QualifiedName visitIdentifiers(List<? extends ParserRuleContext> ctx) {
        return new QualifiedName((Iterable)ctx.stream().map(RuleContext::getText).map(StringUtils::unquoteIdentifier).collect(Collectors.toList()));
    }
}

