/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.ppl.parser;

import com.amazon.opendistroforelasticsearch.sql.ast.expression.Alias;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Field;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Let;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.Map;
import com.amazon.opendistroforelasticsearch.sql.ast.expression.UnresolvedExpression;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Aggregation;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Dedupe;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Eval;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Filter;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Head;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Project;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.RareTopN;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Relation;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Rename;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.Sort;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.UnresolvedPlan;
import com.amazon.opendistroforelasticsearch.sql.common.utils.StringUtils;
import com.amazon.opendistroforelasticsearch.sql.ppl.antlr.parser.OpenDistroPPLParser;
import com.amazon.opendistroforelasticsearch.sql.ppl.antlr.parser.OpenDistroPPLParserBaseVisitor;
import com.amazon.opendistroforelasticsearch.sql.ppl.parser.AstExpressionBuilder;
import com.amazon.opendistroforelasticsearch.sql.ppl.utils.ArgumentFactory;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class AstBuilder
extends OpenDistroPPLParserBaseVisitor<UnresolvedPlan> {
    private final AstExpressionBuilder expressionBuilder;
    private final String query;

    @Override
    public UnresolvedPlan visitPplStatement(OpenDistroPPLParser.PplStatementContext ctx) {
        UnresolvedPlan search = (UnresolvedPlan)this.visit((ParseTree)ctx.searchCommand());
        return ctx.commands().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).reduce(search, (r, e) -> e.attach(r));
    }

    @Override
    public UnresolvedPlan visitSearchFrom(OpenDistroPPLParser.SearchFromContext ctx) {
        return this.visitFromClause(ctx.fromClause());
    }

    @Override
    public UnresolvedPlan visitSearchFromFilter(OpenDistroPPLParser.SearchFromFilterContext ctx) {
        return new Filter(this.visitExpression((ParseTree)ctx.logicalExpression())).attach((UnresolvedPlan)this.visit((ParseTree)ctx.fromClause()));
    }

    @Override
    public UnresolvedPlan visitSearchFilterFrom(OpenDistroPPLParser.SearchFilterFromContext ctx) {
        return new Filter(this.visitExpression((ParseTree)ctx.logicalExpression())).attach((UnresolvedPlan)this.visit((ParseTree)ctx.fromClause()));
    }

    @Override
    public UnresolvedPlan visitWhereCommand(OpenDistroPPLParser.WhereCommandContext ctx) {
        return new Filter(this.visitExpression((ParseTree)ctx.logicalExpression()));
    }

    @Override
    public UnresolvedPlan visitFieldsCommand(OpenDistroPPLParser.FieldsCommandContext ctx) {
        return new Project(ctx.fieldList().fieldExpression().stream().map(this::visitExpression).collect(Collectors.toList()), ArgumentFactory.getArgumentList(ctx));
    }

    @Override
    public UnresolvedPlan visitRenameCommand(OpenDistroPPLParser.RenameCommandContext ctx) {
        return new Rename(ctx.renameClasue().stream().map(ct -> new Map(this.visitExpression((ParseTree)ct.orignalField), this.visitExpression((ParseTree)ct.renamedField))).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedPlan visitStatsCommand(OpenDistroPPLParser.StatsCommandContext ctx) {
        ImmutableList.Builder aggListBuilder = new ImmutableList.Builder();
        for (OpenDistroPPLParser.StatsAggTermContext aggCtx : ctx.statsAggTerm()) {
            UnresolvedExpression aggExpression = this.visitExpression((ParseTree)aggCtx.statsFunction());
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier((String)aggCtx.alias.getText());
            Alias alias = new Alias(name, aggExpression);
            aggListBuilder.add((Object)alias);
        }
        List groupList = ctx.byClause() == null ? Collections.emptyList() : ctx.byClause().fieldList().fieldExpression().stream().map(groupCtx -> new Alias(this.getTextInQuery((ParserRuleContext)groupCtx), this.visitExpression((ParseTree)groupCtx))).collect(Collectors.toList());
        Aggregation aggregation = new Aggregation((List)aggListBuilder.build(), Collections.emptyList(), groupList, ArgumentFactory.getArgumentList(ctx));
        return aggregation;
    }

    @Override
    public UnresolvedPlan visitDedupCommand(OpenDistroPPLParser.DedupCommandContext ctx) {
        return new Dedupe(ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()));
    }

    @Override
    public UnresolvedPlan visitHeadCommand(OpenDistroPPLParser.HeadCommandContext ctx) {
        Integer size = ctx.number != null ? Integer.parseInt(ctx.number.getText()) : 10;
        return new Head(size);
    }

    @Override
    public UnresolvedPlan visitSortCommand(OpenDistroPPLParser.SortCommandContext ctx) {
        return new Sort(ctx.sortbyClause().sortField().stream().map(sort -> (Field)this.visitExpression((ParseTree)sort)).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedPlan visitEvalCommand(OpenDistroPPLParser.EvalCommandContext ctx) {
        return new Eval(ctx.evalClause().stream().map(ct -> (Let)this.visitExpression((ParseTree)ct)).collect(Collectors.toList()));
    }

    private List<UnresolvedExpression> getGroupByList(OpenDistroPPLParser.ByClauseContext ctx) {
        return ctx.fieldList().fieldExpression().stream().map(this::visitExpression).collect(Collectors.toList());
    }

    private List<Field> getFieldList(OpenDistroPPLParser.FieldListContext ctx) {
        return ctx.fieldExpression().stream().map(field -> (Field)this.visitExpression((ParseTree)field)).collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitRareCommand(OpenDistroPPLParser.RareCommandContext ctx) {
        List groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        return new RareTopN(RareTopN.CommandType.RARE, ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitTopCommand(OpenDistroPPLParser.TopCommandContext ctx) {
        List groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        return new RareTopN(RareTopN.CommandType.TOP, ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitFromClause(OpenDistroPPLParser.FromClauseContext ctx) {
        return new Relation(this.visitExpression((ParseTree)ctx.tableSource()));
    }

    private UnresolvedExpression visitExpression(ParseTree tree) {
        return (UnresolvedExpression)this.expressionBuilder.visit(tree);
    }

    protected UnresolvedPlan aggregateResult(UnresolvedPlan aggregate, UnresolvedPlan nextResult) {
        if (nextResult != this.defaultResult()) {
            return nextResult;
        }
        return aggregate;
    }

    private String getTextInQuery(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        return this.query.substring(start.getStartIndex(), stop.getStopIndex() + 1);
    }

    @Generated
    public AstBuilder(AstExpressionBuilder expressionBuilder, String query) {
        this.expressionBuilder = expressionBuilder;
        this.query = query;
    }
}

