/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.ppl.domain;

import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.Format;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONObject;

public class PPLQueryRequest {
    public static final PPLQueryRequest NULL = new PPLQueryRequest("", null, "", "");
    private final String pplQuery;
    private final JSONObject jsonContent;
    private final String path;
    private String format = "";
    private boolean sanitize = true;

    public PPLQueryRequest(String pplQuery, JSONObject jsonContent, String path, String format) {
        this.pplQuery = pplQuery;
        this.jsonContent = jsonContent;
        this.path = path;
        this.format = format;
    }

    public String getRequest() {
        return this.pplQuery;
    }

    public boolean isExplainRequest() {
        return this.path.endsWith("/_explain");
    }

    public Format format() {
        Optional optionalFormat = Format.of((String)this.format);
        if (optionalFormat.isPresent()) {
            return (Format)optionalFormat.get();
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "response in %s format is not supported.", this.format));
    }

    @Generated
    public PPLQueryRequest(String pplQuery, JSONObject jsonContent, String path) {
        this.pplQuery = pplQuery;
        this.jsonContent = jsonContent;
        this.path = path;
    }

    @Generated
    public PPLQueryRequest sanitize(boolean sanitize) {
        this.sanitize = sanitize;
        return this;
    }

    @Generated
    public boolean sanitize() {
        return this.sanitize;
    }
}

