/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.ppl;

import com.amazon.opendistroforelasticsearch.sql.analysis.AnalysisContext;
import com.amazon.opendistroforelasticsearch.sql.analysis.Analyzer;
import com.amazon.opendistroforelasticsearch.sql.ast.tree.UnresolvedPlan;
import com.amazon.opendistroforelasticsearch.sql.common.response.ResponseListener;
import com.amazon.opendistroforelasticsearch.sql.common.utils.LogUtils;
import com.amazon.opendistroforelasticsearch.sql.executor.ExecutionEngine;
import com.amazon.opendistroforelasticsearch.sql.expression.DSL;
import com.amazon.opendistroforelasticsearch.sql.expression.function.BuiltinFunctionRepository;
import com.amazon.opendistroforelasticsearch.sql.planner.Planner;
import com.amazon.opendistroforelasticsearch.sql.planner.logical.LogicalPlan;
import com.amazon.opendistroforelasticsearch.sql.planner.optimizer.LogicalPlanOptimizer;
import com.amazon.opendistroforelasticsearch.sql.planner.physical.PhysicalPlan;
import com.amazon.opendistroforelasticsearch.sql.ppl.antlr.PPLSyntaxParser;
import com.amazon.opendistroforelasticsearch.sql.ppl.domain.PPLQueryRequest;
import com.amazon.opendistroforelasticsearch.sql.ppl.parser.AstBuilder;
import com.amazon.opendistroforelasticsearch.sql.ppl.parser.AstExpressionBuilder;
import com.amazon.opendistroforelasticsearch.sql.ppl.utils.PPLQueryDataAnonymizer;
import com.amazon.opendistroforelasticsearch.sql.ppl.utils.UnresolvedPlanHelper;
import com.amazon.opendistroforelasticsearch.sql.storage.StorageEngine;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PPLService {
    private final PPLSyntaxParser parser;
    private final Analyzer analyzer;
    private final StorageEngine storageEngine;
    private final ExecutionEngine executionEngine;
    private final BuiltinFunctionRepository repository;
    private final PPLQueryDataAnonymizer anonymizer = new PPLQueryDataAnonymizer();
    private static final Logger LOG = LogManager.getLogger();

    public void execute(PPLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            this.executionEngine.execute(this.plan(request), listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void explain(PPLQueryRequest request, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        try {
            this.executionEngine.explain(this.plan(request), listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private PhysicalPlan plan(PPLQueryRequest request) {
        ParseTree cst = this.parser.analyzeSyntax(request.getRequest());
        UnresolvedPlan ast = (UnresolvedPlan)cst.accept((ParseTreeVisitor)new AstBuilder(new AstExpressionBuilder(), request.getRequest()));
        LOG.info("[{}] Incoming request {}", (Object)LogUtils.getRequestId(), (Object)this.anonymizer.anonymizeData(ast));
        LogicalPlan logicalPlan = this.analyzer.analyze(UnresolvedPlanHelper.addSelectAll(ast), new AnalysisContext());
        return new Planner(this.storageEngine, LogicalPlanOptimizer.create((DSL)new DSL(this.repository))).plan(logicalPlan);
    }

    @Generated
    public PPLService(PPLSyntaxParser parser, Analyzer analyzer, StorageEngine storageEngine, ExecutionEngine executionEngine, BuiltinFunctionRepository repository) {
        this.parser = parser;
        this.analyzer = analyzer;
        this.storageEngine = storageEngine;
        this.executionEngine = executionEngine;
        this.repository = repository;
    }
}

