/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.plugin.rest;

import com.amazon.opendistroforelasticsearch.sql.legacy.executor.format.ErrorMessageFactory;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.LogUtils;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestPPLStatsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestPPLStatsAction.class);
    public static final String PPL_STATS_API_ENDPOINT = "/_opendistro/_ppl/stats";

    public RestPPLStatsAction(Settings settings, RestController restController) {
    }

    public String getName() {
        return "ppl_stats_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, PPL_STATS_API_ENDPOINT), (Object)new RestHandler.Route(RestRequest.Method.GET, PPL_STATS_API_ENDPOINT));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        LogUtils.addRequestId();
        try {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, Metrics.getInstance().collectToJSON()));
        }
        catch (Exception e) {
            LOG.error("Failed during Query PPL STATS Action.", (Throwable)e);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, ErrorMessageFactory.createErrorMessage((Exception)e, (int)RestStatus.SERVICE_UNAVAILABLE.getStatus()).toString()));
        }
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("format", "sanitize"));
        return responseParams;
    }
}

