/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.plugin.rest;

import com.amazon.opendistroforelasticsearch.sql.common.antlr.SyntaxCheckException;
import com.amazon.opendistroforelasticsearch.sql.common.response.ResponseListener;
import com.amazon.opendistroforelasticsearch.sql.common.setting.Settings;
import com.amazon.opendistroforelasticsearch.sql.common.utils.LogUtils;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.response.error.ErrorMessageFactory;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.security.SecurityAccess;
import com.amazon.opendistroforelasticsearch.sql.exception.ExpressionEvaluationException;
import com.amazon.opendistroforelasticsearch.sql.exception.QueryEngineException;
import com.amazon.opendistroforelasticsearch.sql.exception.SemanticCheckException;
import com.amazon.opendistroforelasticsearch.sql.executor.ExecutionEngine;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.MetricName;
import com.amazon.opendistroforelasticsearch.sql.legacy.metrics.Metrics;
import com.amazon.opendistroforelasticsearch.sql.plugin.request.PPLQueryRequestFactory;
import com.amazon.opendistroforelasticsearch.sql.plugin.rest.ElasticsearchPluginConfig;
import com.amazon.opendistroforelasticsearch.sql.ppl.PPLService;
import com.amazon.opendistroforelasticsearch.sql.ppl.config.PPLServiceConfig;
import com.amazon.opendistroforelasticsearch.sql.ppl.domain.PPLQueryRequest;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.QueryResult;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.CsvResponseFormatter;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.Format;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.JsonResponseFormatter;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.ResponseFormatter;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.SimpleJsonResponseFormatter;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class RestPPLQueryAction
extends BaseRestHandler {
    public static final String QUERY_API_ENDPOINT = "/_opendistro/_ppl";
    public static final String EXPLAIN_API_ENDPOINT = "/_opendistro/_ppl/_explain";
    private static final Logger LOG = LogManager.getLogger();
    private final ClusterService clusterService;
    private final com.amazon.opendistroforelasticsearch.sql.common.setting.Settings pluginSettings;
    private final Supplier<Boolean> pplEnabled;
    private PPLQueryRequest pplRequest;

    public RestPPLQueryAction(RestController restController, ClusterService clusterService, com.amazon.opendistroforelasticsearch.sql.common.setting.Settings pluginSettings, Settings clusterSettings) {
        this.clusterService = clusterService;
        this.pluginSettings = pluginSettings;
        this.pplEnabled = () -> (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(clusterSettings) != false && (Boolean)pluginSettings.getSettingValue(Settings.Key.PPL_ENABLED) != false;
    }

    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, QUERY_API_ENDPOINT), new RestHandler.Route(RestRequest.Method.POST, EXPLAIN_API_ENDPOINT));
    }

    public String getName() {
        return "ppl_query_action";
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("format", "sanitize"));
        return responseParams;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) {
        Metrics.getInstance().getNumericalMetric(MetricName.PPL_REQ_TOTAL).increment();
        Metrics.getInstance().getNumericalMetric(MetricName.PPL_REQ_COUNT_TOTAL).increment();
        LogUtils.addRequestId();
        if (!this.pplEnabled.get().booleanValue()) {
            return channel -> this.reportError((RestChannel)channel, new IllegalAccessException("Either opendistro.ppl.enabled or rest.action.multi.allow_explicit_index setting is false"), RestStatus.BAD_REQUEST);
        }
        PPLService pplService = this.createPPLService(nodeClient);
        this.pplRequest = PPLQueryRequestFactory.getPPLRequest(request);
        if (this.pplRequest.isExplainRequest()) {
            return channel -> pplService.explain(this.pplRequest, this.createExplainResponseListener((RestChannel)channel));
        }
        return channel -> pplService.execute(this.pplRequest, this.createListener((RestChannel)channel));
    }

    private PPLService createPPLService(NodeClient client) {
        return this.doPrivileged(() -> {
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
            context.registerBean(ClusterService.class, () -> this.clusterService, new BeanDefinitionCustomizer[0]);
            context.registerBean(NodeClient.class, () -> client, new BeanDefinitionCustomizer[0]);
            context.registerBean(com.amazon.opendistroforelasticsearch.sql.common.setting.Settings.class, () -> this.pluginSettings, new BeanDefinitionCustomizer[0]);
            context.register(new Class[]{ElasticsearchPluginConfig.class});
            context.register(new Class[]{PPLServiceConfig.class});
            context.refresh();
            return (PPLService)context.getBean(PPLService.class);
        });
    }

    private ResponseListener<ExecutionEngine.ExplainResponse> createExplainResponseListener(final RestChannel channel) {
        return new ResponseListener<ExecutionEngine.ExplainResponse>(){

            public void onResponse(ExecutionEngine.ExplainResponse response) {
                RestPPLQueryAction.this.sendResponse(channel, RestStatus.OK, new JsonResponseFormatter<ExecutionEngine.ExplainResponse>(JsonResponseFormatter.Style.PRETTY){

                    protected Object buildJsonObject(ExecutionEngine.ExplainResponse response) {
                        return response;
                    }
                }.format((Object)response));
            }

            public void onFailure(Exception e) {
                LOG.error("Error happened during explain", (Throwable)e);
                RestPPLQueryAction.this.sendResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, "Failed to explain the query due to error: " + e.getMessage());
            }
        };
    }

    private ResponseListener<ExecutionEngine.QueryResponse> createListener(final RestChannel channel) {
        Format format = this.pplRequest.format();
        Object formatter = format.equals((Object)Format.CSV) ? new CsvResponseFormatter(this.pplRequest.sanitize()) : new SimpleJsonResponseFormatter(JsonResponseFormatter.Style.PRETTY);
        return new ResponseListener<ExecutionEngine.QueryResponse>(){
            final /* synthetic */ ResponseFormatter val$formatter;
            {
                this.val$formatter = responseFormatter;
            }

            public void onResponse(ExecutionEngine.QueryResponse response) {
                RestPPLQueryAction.this.sendResponse(channel, RestStatus.OK, this.val$formatter.format((Object)new QueryResult(response.getSchema(), (Collection)response.getResults())));
            }

            public void onFailure(Exception e) {
                LOG.error("Error happened during query handling", (Throwable)e);
                if (RestPPLQueryAction.isClientError(e)) {
                    Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_CUS).increment();
                    RestPPLQueryAction.this.reportError(channel, e, RestStatus.BAD_REQUEST);
                } else {
                    Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_SYS).increment();
                    RestPPLQueryAction.this.reportError(channel, e, RestStatus.SERVICE_UNAVAILABLE);
                }
            }
        };
    }

    private <T> T doPrivileged(PrivilegedExceptionAction<T> action) {
        try {
            return (T)SecurityAccess.doPrivileged(action);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to perform privileged action", e);
        }
    }

    private void sendResponse(RestChannel channel, RestStatus status, String content) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, "application/json; charset=UTF-8", content));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, ErrorMessageFactory.createErrorMessage((Throwable)e, (int)status.getStatus()).toString()));
    }

    private static boolean isClientError(Exception e) {
        return e instanceof NullPointerException || e instanceof IllegalArgumentException || e instanceof IndexNotFoundException || e instanceof SemanticCheckException || e instanceof ExpressionEvaluationException || e instanceof QueryEngineException || e instanceof SyntaxCheckException;
    }
}

