/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.plugin.rest;

import com.amazon.opendistroforelasticsearch.sql.common.setting.Settings;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.client.ElasticsearchClient;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.client.ElasticsearchNodeClient;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.executor.ElasticsearchExecutionEngine;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.executor.protector.ElasticsearchExecutionProtector;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.executor.protector.ExecutionProtector;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.monitor.ElasticsearchMemoryHealthy;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.monitor.ElasticsearchResourceMonitor;
import com.amazon.opendistroforelasticsearch.sql.elasticsearch.storage.ElasticsearchStorageEngine;
import com.amazon.opendistroforelasticsearch.sql.executor.ExecutionEngine;
import com.amazon.opendistroforelasticsearch.sql.monitor.ResourceMonitor;
import com.amazon.opendistroforelasticsearch.sql.storage.StorageEngine;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticsearchPluginConfig {
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private NodeClient nodeClient;
    @Autowired
    private Settings settings;

    @Bean
    public ElasticsearchClient client() {
        return new ElasticsearchNodeClient(this.clusterService, this.nodeClient);
    }

    @Bean
    public StorageEngine storageEngine() {
        return new ElasticsearchStorageEngine(this.client(), this.settings);
    }

    @Bean
    public ExecutionEngine executionEngine() {
        return new ElasticsearchExecutionEngine(this.client(), this.protector());
    }

    @Bean
    public ResourceMonitor resourceMonitor() {
        return new ElasticsearchResourceMonitor(this.settings, new ElasticsearchMemoryHealthy());
    }

    @Bean
    public ExecutionProtector protector() {
        return new ElasticsearchExecutionProtector(this.resourceMonitor());
    }
}

