/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.plugin.request;

import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.ppl.domain.PPLQueryRequest;
import com.amazon.opendistroforelasticsearch.sql.protocol.response.format.Format;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.rest.RestRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class PPLQueryRequestFactory {
    private static final String PPL_URL_PARAM_KEY = "ppl";
    private static final String PPL_FIELD_NAME = "query";
    private static final String QUERY_PARAMS_FORMAT = "format";
    private static final String QUERY_PARAMS_SANITIZE = "sanitize";

    public static PPLQueryRequest getPPLRequest(RestRequest request) {
        switch (request.method()) {
            case GET: {
                return PPLQueryRequestFactory.parsePPLRequestFromUrl(request);
            }
            case POST: {
                return PPLQueryRequestFactory.parsePPLRequestFromPayload(request);
            }
        }
        throw new IllegalArgumentException("ES PPL doesn't supported HTTP " + request.method().name());
    }

    private static PPLQueryRequest parsePPLRequestFromUrl(RestRequest restRequest) {
        String ppl = restRequest.param(PPL_URL_PARAM_KEY);
        if (ppl == null) {
            throw new IllegalArgumentException("Cannot find ppl parameter from the URL");
        }
        return new PPLQueryRequest(ppl, null, restRequest.path());
    }

    private static PPLQueryRequest parsePPLRequestFromPayload(RestRequest restRequest) {
        JSONObject jsonContent;
        String content = restRequest.content().utf8ToString();
        Format format = PPLQueryRequestFactory.getFormat(restRequest.params());
        try {
            jsonContent = new JSONObject(content);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to parse request payload", e);
        }
        PPLQueryRequest pplRequest = new PPLQueryRequest(jsonContent.getString(PPL_FIELD_NAME), jsonContent, restRequest.path(), format.getFormatName());
        if (format.equals((Object)Format.CSV)) {
            pplRequest.sanitize(PPLQueryRequestFactory.getSanitizeOption(restRequest.params()));
        }
        return pplRequest;
    }

    private static Format getFormat(Map<String, String> requestParams) {
        String formatName;
        if (requestParams.containsKey(QUERY_PARAMS_FORMAT)) {
            formatName = requestParams.get(QUERY_PARAMS_FORMAT).toLowerCase();
        } else {
            LocalClusterState clusterState = LocalClusterState.state();
            formatName = (String)clusterState.getSettingValue("opendistro.sql.query.response.format");
        }
        Optional optionalFormat = Format.of((String)formatName);
        if (optionalFormat.isPresent()) {
            return (Format)optionalFormat.get();
        }
        throw new IllegalArgumentException("Failed to create executor due to unknown response format: " + formatName);
    }

    private static boolean getSanitizeOption(Map<String, String> requestParams) {
        if (requestParams.containsKey(QUERY_PARAMS_SANITIZE)) {
            return Boolean.parseBoolean(requestParams.get(QUERY_PARAMS_SANITIZE));
        }
        return true;
    }
}

