/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.utils;

import com.google.common.base.Strings;
import com.google.common.primitives.Doubles;
import java.util.Locale;

public class StringUtils {
    public static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    public static String toLower(String input) {
        return input.toLowerCase(Locale.ROOT);
    }

    public static String toUpper(String input) {
        return input.toUpperCase(Locale.ROOT);
    }

    public static int countMatches(CharSequence input, char match) {
        return Math.toIntExact(input.chars().filter(c -> c == match).count());
    }

    public static String unquoteSingleField(String text, String quote) {
        if (StringUtils.isQuoted(text, quote)) {
            return text.substring(quote.length(), text.length() - quote.length());
        }
        return text;
    }

    public static String unquoteSingleField(String text) {
        return StringUtils.unquoteSingleField(text, "`");
    }

    public static String unquoteFullColumn(String text, String quote) {
        CharSequence[] strs = text.split("\\.");
        for (int i = 0; i < strs.length; ++i) {
            String unquotedSubstr = StringUtils.unquoteSingleField(strs[i], quote);
            strs[i] = unquotedSubstr;
        }
        return String.join((CharSequence)".", strs);
    }

    public static String unquoteFullColumn(String text) {
        return StringUtils.unquoteFullColumn(text, "`");
    }

    public static boolean isQuoted(String text, String quote) {
        return !Strings.isNullOrEmpty((String)text) && text.startsWith(quote) && text.endsWith(quote);
    }

    public static boolean isNumeric(String text) {
        return Doubles.tryParse((String)text) != null;
    }

    private StringUtils() {
        throw new AssertionError((Object)(this.getClass().getCanonicalName() + " is a utility class and must not be initialized"));
    }
}

