/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.utils;

import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.ThreadContext;

public class LogUtils {
    private static final String REQUEST_ID_KEY = "request_id";

    public static void addRequestId() {
        ThreadContext.put((String)REQUEST_ID_KEY, (String)UUID.randomUUID().toString());
    }

    public static String getRequestId() {
        String requestId = ThreadContext.get((String)REQUEST_ID_KEY);
        if (requestId == null) {
            throw new IllegalStateException("Request id not present in current context");
        }
        return requestId;
    }

    public static Runnable withCurrentContext(Runnable task) {
        Map currentContext = ThreadContext.getImmutableContext();
        return () -> {
            ThreadContext.putAll((Map)currentContext);
            task.run();
        };
    }

    private LogUtils() {
        throw new AssertionError((Object)(this.getClass().getCanonicalName() + " is a utility class and must not be initialized"));
    }
}

