/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.nestedfield;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.matchtoterm.VerificationException;
import com.amazon.opendistroforelasticsearch.sql.legacy.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class NestedFieldProjection {
    private final SearchRequestBuilder request;

    public NestedFieldProjection(SearchRequestBuilder request) {
        this.request = request;
    }

    public void project(List<Field> fields, SQLJoinTableSource.JoinType nestedJoinType) {
        if (this.isAnyNestedField(fields)) {
            this.initBoolQueryFilterIfNull();
            List<NestedQueryBuilder> nestedQueries = this.extractNestedQueries((QueryBuilder)this.query());
            if (nestedJoinType == SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN) {
                Map<String, List<String>> fieldNamesByPath = this.groupFieldNamesByPath(fields);
                if (fieldNamesByPath.size() > 1) {
                    String message = StringUtils.format("only single nested field is allowed as right table for LEFT JOIN, found %s ", fieldNamesByPath.keySet());
                    throw new VerificationException(message);
                }
                Map.Entry<String, List<String>> pathToFields = fieldNamesByPath.entrySet().iterator().next();
                String path2 = pathToFields.getKey();
                List<String> fieldNames2 = pathToFields.getValue();
                this.buildNestedLeftJoinQuery(path2, fieldNames2);
            } else {
                this.groupFieldNamesByPath(fields).forEach((path, fieldNames) -> this.buildInnerHit((List<String>)fieldNames, this.findNestedQueryWithSamePath(nestedQueries, (String)path)));
            }
        }
    }

    private boolean isAnyNestedField(List<Field> fields) {
        for (Field field : fields) {
            if (!field.isNested() || field.isReverseNested()) continue;
            return true;
        }
        return false;
    }

    private void initBoolQueryFilterIfNull() {
        if (((SearchRequest)this.request.request()).source() == null || this.query() == null) {
            this.request.setQuery((QueryBuilder)QueryBuilders.boolQuery());
        }
        if (this.query().filter().isEmpty()) {
            this.query().filter((QueryBuilder)QueryBuilders.boolQuery());
        }
    }

    private Map<String, List<String>> groupFieldNamesByPath(List<Field> fields) {
        return fields.stream().filter(Field::isNested).filter(this.not(Field::isReverseNested)).collect(Collectors.groupingBy(Field::getNestedPath, Collectors.mapping(Field::getName, Collectors.toList())));
    }

    private List<NestedQueryBuilder> extractNestedQueries(QueryBuilder query) {
        ArrayList<NestedQueryBuilder> result = new ArrayList<NestedQueryBuilder>();
        if (query instanceof NestedQueryBuilder) {
            result.add((NestedQueryBuilder)query);
        } else if (query instanceof BoolQueryBuilder) {
            BoolQueryBuilder boolQ = (BoolQueryBuilder)query;
            Stream.of(boolQ.filter(), boolQ.must(), boolQ.should()).flatMap(Collection::stream).forEach(q -> result.addAll(this.extractNestedQueries((QueryBuilder)q)));
        }
        return result;
    }

    private void buildInnerHit(List<String> fieldNames, NestedQueryBuilder query) {
        query.innerHit(new InnerHitBuilder().setFetchSourceContext(new FetchSourceContext(true, fieldNames.toArray(new String[0]), null)));
    }

    private NestedQueryBuilder findNestedQueryWithSamePath(List<NestedQueryBuilder> nestedQueries, String path) {
        return nestedQueries.stream().filter(query -> this.isSamePath(path, (NestedQueryBuilder)query)).findAny().orElseGet(this.createEmptyNestedQuery(path));
    }

    private boolean isSamePath(String path, NestedQueryBuilder query) {
        return QueryBuilders.nestedQuery((String)path, (QueryBuilder)query.query(), (ScoreMode)query.scoreMode()).equals((Object)query);
    }

    private Supplier<NestedQueryBuilder> createEmptyNestedQuery(String path) {
        return () -> {
            NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)path, (QueryBuilder)QueryBuilders.matchAllQuery(), (ScoreMode)ScoreMode.None);
            ((BoolQueryBuilder)this.query().filter().get(0)).must((QueryBuilder)nestedQuery);
            return nestedQuery;
        };
    }

    private BoolQueryBuilder query() {
        return (BoolQueryBuilder)((SearchRequest)this.request.request()).source().query();
    }

    private <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    private void buildNestedLeftJoinQuery(String path, List<String> fieldNames) {
        BoolQueryBuilder existsNestedQuery = QueryBuilders.boolQuery();
        existsNestedQuery.mustNot().add(QueryBuilders.nestedQuery((String)path, (QueryBuilder)QueryBuilders.existsQuery((String)path), (ScoreMode)ScoreMode.None));
        NestedQueryBuilder matchAllNestedQuery = QueryBuilders.nestedQuery((String)path, (QueryBuilder)QueryBuilders.matchAllQuery(), (ScoreMode)ScoreMode.None);
        this.buildInnerHit(fieldNames, matchAllNestedQuery);
        ((BoolQueryBuilder)this.query().filter().get(0)).should().add(existsNestedQuery);
        ((BoolQueryBuilder)this.query().filter().get(0)).should().add(matchAllNestedQuery);
    }
}

