/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.nestedfield;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.nestedfield.Identifier;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.nestedfield.SQLClause;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.nestedfield.Scope;

class From
extends SQLClause<SQLTableSource> {
    From(SQLTableSource expr) {
        super(expr);
    }

    @Override
    void rewrite(Scope scope) {
        if (!this.isJoin()) {
            return;
        }
        if (!this.isCommaJoin()) {
            scope.setActualJoinType(((SQLJoinTableSource)this.expr).getJoinType());
            ((SQLJoinTableSource)this.expr).setJoinType(SQLJoinTableSource.JoinType.COMMA);
        }
        if (this.parentAlias(scope).isEmpty()) {
            if (scope.getActualJoinType() != null) {
                ((SQLJoinTableSource)this.expr).setJoinType(scope.getActualJoinType());
            }
            return;
        }
        this.collectNestedFields(scope);
        if (scope.isAnyNestedField()) {
            this.eraseParentAlias();
            this.keepParentTableOnly();
        } else if (scope.getActualJoinType() != null) {
            ((SQLJoinTableSource)this.expr).setJoinType(scope.getActualJoinType());
        }
    }

    private String parentAlias(Scope scope) {
        scope.setParentAlias(((SQLJoinTableSource)this.expr).getLeft().getAlias());
        return this.emptyIfNull(scope.getParentAlias());
    }

    private void eraseParentAlias() {
        ((SQLTableSource)this.left().expr).setAlias(null);
    }

    private void keepParentTableOnly() {
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)((SQLTableSource)this.expr).getParent();
        query.setFrom((SQLTableSource)this.left().expr);
        ((SQLTableSource)this.left().expr).setParent((SQLObject)query);
    }

    private void collectNestedFields(Scope scope) {
        From clause = this;
        while (clause.isCommaJoin()) {
            clause.left().addIfNestedField(scope);
            clause = clause.right();
        }
        clause.addIfNestedField(scope);
    }

    private boolean isCommaJoin() {
        return this.expr instanceof SQLJoinTableSource && ((SQLJoinTableSource)this.expr).getJoinType() == SQLJoinTableSource.JoinType.COMMA;
    }

    private boolean isJoin() {
        return this.expr instanceof SQLJoinTableSource;
    }

    private From left() {
        return new From(((SQLJoinTableSource)this.expr).getLeft());
    }

    private From right() {
        return new From(((SQLJoinTableSource)this.expr).getRight());
    }

    private void addIfNestedField(Scope scope) {
        if (!(this.expr instanceof SQLExprTableSource) || !(((SQLExprTableSource)this.expr).getExpr() instanceof SQLIdentifierExpr)) {
            return;
        }
        Identifier table = new Identifier((SQLIdentifierExpr)((SQLExprTableSource)this.expr).getExpr());
        if (table.path().equals(scope.getParentAlias())) {
            scope.addAliasFullPath(this.emptyIfNull(((SQLTableSource)this.expr).getAlias()), table.name());
        }
    }

    private String emptyIfNull(String str) {
        return str == null ? "" : str;
    }
}

