/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.matchtoterm;

import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.mapping.FieldMappings;
import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.mapping.IndexMappings;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.matchtoterm.VerificationException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class TermFieldScope {
    private IndexMappings mapper = IndexMappings.EMPTY;
    private FieldMappings finalMapping;
    private Map<String, String> aliases = new HashMap<String, String>();

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public IndexMappings getMapper() {
        return this.mapper;
    }

    public void setMapper(IndexMappings mapper) {
        this.mapper = mapper;
    }

    public Optional<Map<String, Object>> resolveFieldMapping(String fieldName) {
        Set indexMappings = this.mapper.allMappings().stream().flatMap(typeMappings -> typeMappings.allMappings().stream()).collect(Collectors.toSet());
        Optional<Map<String, Object>> resolvedMapping = indexMappings.stream().filter(mapping -> mapping.has(fieldName)).map(mapping -> mapping.mapping(fieldName)).reduce((map1, map2) -> {
            if (!map1.equals(map2)) {
                String exceptionReason = String.format(Locale.ROOT, "Different mappings are not allowed for the same field[%s]: found [%s] and [%s] ", fieldName, TermFieldScope.pretty(map1), TermFieldScope.pretty(map2));
                throw new VerificationException(exceptionReason);
            }
            return map1;
        });
        return resolvedMapping;
    }

    private static String pretty(Map<String, Object> mapping) {
        return new JSONObject(mapping).toString().replaceAll("\"", "");
    }
}

