/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.rewriter;

import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.amazon.opendistroforelasticsearch.sql.legacy.rewriter.RewriteRule;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;

public class RewriteRuleExecutor<T extends SQLQueryExpr> {
    private final List<RewriteRule<T>> rewriteRules;

    public RewriteRuleExecutor(List<RewriteRule<T>> rewriteRules) {
        this.rewriteRules = rewriteRules;
    }

    public void executeOn(T expr) throws SQLFeatureNotSupportedException {
        for (RewriteRule<T> rule : this.rewriteRules) {
            if (!rule.match(expr)) continue;
            rule.rewrite(expr);
        }
    }

    public static <T extends SQLQueryExpr> BuilderOptimizer<T> builder() {
        return new BuilderOptimizer();
    }

    public static class BuilderOptimizer<T extends SQLQueryExpr> {
        private List<RewriteRule<T>> rewriteRules;

        public BuilderOptimizer<T> withRule(RewriteRule<T> rule) {
            if (this.rewriteRules == null) {
                this.rewriteRules = new ArrayList<RewriteRule<T>>();
            }
            this.rewriteRules.add(rule);
            return this;
        }

        public RewriteRuleExecutor<T> build() {
            return new RewriteRuleExecutor<T>(this.rewriteRules);
        }
    }
}

