/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.request;

import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.executor.Format;
import java.util.Map;
import java.util.Optional;

public class SqlRequestParam {
    public static final String QUERY_PARAMS_FORMAT = "format";
    public static final String QUERY_PARAMS_PRETTY = "pretty";
    public static final String QUERY_PARAMS_ESCAPE = "escape";

    public static boolean isPrettyFormat(Map<String, String> requestParams) {
        return requestParams.containsKey(QUERY_PARAMS_PRETTY) && ("".equals(requestParams.get(QUERY_PARAMS_PRETTY)) || "true".equals(requestParams.get(QUERY_PARAMS_PRETTY)));
    }

    public static Format getFormat(Map<String, String> requestParams) {
        String formatName;
        if (requestParams.containsKey(QUERY_PARAMS_FORMAT)) {
            formatName = requestParams.get(QUERY_PARAMS_FORMAT).toLowerCase();
        } else {
            LocalClusterState clusterState = LocalClusterState.state();
            formatName = (String)clusterState.getSettingValue("opendistro.sql.query.response.format");
        }
        Optional<Format> optionalFormat = Format.of(formatName);
        if (optionalFormat.isPresent()) {
            return optionalFormat.get();
        }
        throw new IllegalArgumentException("Failed to create executor due to unknown response format: " + formatName);
    }

    public static boolean getEscapeOption(Map<String, String> requestParams) {
        if (requestParams.containsKey(QUERY_PARAMS_ESCAPE)) {
            return Boolean.parseBoolean(requestParams.get(QUERY_PARAMS_ESCAPE));
        }
        return false;
    }
}

