/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.request;

import com.amazon.opendistroforelasticsearch.sql.legacy.esdomain.LocalClusterState;
import com.amazon.opendistroforelasticsearch.sql.legacy.request.PreparedStatementRequest;
import com.amazon.opendistroforelasticsearch.sql.legacy.request.SqlRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.rest.RestRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SqlRequestFactory {
    private static final String SQL_URL_PARAM_KEY = "sql";
    private static final String SQL_FIELD_NAME = "query";
    private static final String PARAM_FIELD_NAME = "parameters";
    private static final String PARAM_TYPE_FIELD_NAME = "type";
    private static final String PARAM_VALUE_FIELD_NAME = "value";
    public static final String SQL_CURSOR_FIELD_NAME = "cursor";
    public static final String SQL_FETCH_FIELD_NAME = "fetch_size";

    public static SqlRequest getSqlRequest(RestRequest request) {
        switch (request.method()) {
            case POST: {
                return SqlRequestFactory.parseSqlRequestFromPayload(request);
            }
        }
        throw new IllegalArgumentException("ES SQL doesn't supported HTTP " + request.method().name());
    }

    private static SqlRequest parseSqlRequestFromUrl(RestRequest restRequest) {
        String sql = restRequest.param(SQL_URL_PARAM_KEY);
        if (sql == null) {
            throw new IllegalArgumentException("Cannot find sql parameter from the URL");
        }
        return new SqlRequest(sql, null);
    }

    private static SqlRequest parseSqlRequestFromPayload(RestRequest restRequest) {
        JSONObject jsonContent;
        String content = restRequest.content().utf8ToString();
        try {
            jsonContent = new JSONObject(content);
            if (jsonContent.has(SQL_CURSOR_FIELD_NAME)) {
                return new SqlRequest(jsonContent.getString(SQL_CURSOR_FIELD_NAME));
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to parse request payload", e);
        }
        String sql = jsonContent.getString(SQL_FIELD_NAME);
        if (jsonContent.has(PARAM_FIELD_NAME)) {
            JSONArray paramArray = jsonContent.getJSONArray(PARAM_FIELD_NAME);
            List<PreparedStatementRequest.PreparedStatementParameter> parameters = SqlRequestFactory.parseParameters(paramArray);
            return new PreparedStatementRequest(sql, SqlRequestFactory.validateAndGetFetchSize(jsonContent), jsonContent, parameters);
        }
        return new SqlRequest(sql, SqlRequestFactory.validateAndGetFetchSize(jsonContent), jsonContent);
    }

    private static Integer validateAndGetFetchSize(JSONObject jsonContent) {
        Optional<Object> fetchSize = Optional.empty();
        try {
            if (jsonContent.has(SQL_FETCH_FIELD_NAME) && (Integer)(fetchSize = Optional.of(jsonContent.getInt(SQL_FETCH_FIELD_NAME))).get() < 0) {
                throw new IllegalArgumentException("Fetch_size must be greater or equal to 0");
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to parse field [fetch_size]", e);
        }
        return fetchSize.orElse((Integer)LocalClusterState.state().getSettingValue("opendistro.sql.cursor.fetch_size"));
    }

    private static List<PreparedStatementRequest.PreparedStatementParameter> parseParameters(JSONArray paramsJsonArray) {
        ArrayList<PreparedStatementRequest.PreparedStatementParameter> parameters = new ArrayList<PreparedStatementRequest.PreparedStatementParameter>();
        for (int i = 0; i < paramsJsonArray.length(); ++i) {
            PreparedStatementRequest.ParameterType type;
            JSONObject paramJson = paramsJsonArray.getJSONObject(i);
            String typeString = paramJson.getString(PARAM_TYPE_FIELD_NAME);
            if (typeString == null) {
                throw new IllegalArgumentException("Parameter type cannot be null. parameter json: " + paramJson.toString());
            }
            try {
                type = PreparedStatementRequest.ParameterType.valueOf(typeString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported parameter type " + typeString, e);
            }
            try {
                switch (type) {
                    case BOOLEAN: {
                        PreparedStatementRequest.PreparedStatementParameter parameter = new PreparedStatementRequest.PreparedStatementParameter<Boolean>(paramJson.getBoolean(PARAM_VALUE_FIELD_NAME));
                        parameters.add(parameter);
                        break;
                    }
                    case KEYWORD: 
                    case STRING: 
                    case DATE: {
                        PreparedStatementRequest.PreparedStatementParameter parameter = new PreparedStatementRequest.StringParameter(paramJson.getString(PARAM_VALUE_FIELD_NAME));
                        parameters.add(parameter);
                        break;
                    }
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: 
                    case LONG: {
                        PreparedStatementRequest.PreparedStatementParameter parameter = new PreparedStatementRequest.PreparedStatementParameter<Long>(paramJson.getLong(PARAM_VALUE_FIELD_NAME));
                        parameters.add(parameter);
                        break;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        PreparedStatementRequest.PreparedStatementParameter parameter = new PreparedStatementRequest.PreparedStatementParameter<Double>(paramJson.getDouble(PARAM_VALUE_FIELD_NAME));
                        parameters.add(parameter);
                        break;
                    }
                    case NULL: {
                        PreparedStatementRequest.PreparedStatementParameter parameter = new PreparedStatementRequest.NullParameter();
                        parameters.add(parameter);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Failed to handle parameter type " + type.name());
                    }
                }
                continue;
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Failed to parse PreparedStatement parameters", e);
            }
        }
        return parameters;
    }
}

