/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.request;

import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchModule;
import org.json.JSONException;
import org.json.JSONObject;

public class SqlRequest {
    public static final SqlRequest NULL = new SqlRequest("", null);
    String sql;
    JSONObject jsonContent;
    String cursor;
    Integer fetchSize;

    public SqlRequest(String sql, JSONObject jsonContent) {
        this.sql = sql;
        this.jsonContent = jsonContent;
    }

    public SqlRequest(String cursor) {
        this.cursor = cursor;
    }

    public SqlRequest(String sql, Integer fetchSize, JSONObject jsonContent) {
        this.sql = sql;
        this.fetchSize = fetchSize;
        this.jsonContent = jsonContent;
    }

    private static boolean isValidJson(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    public String getSql() {
        return this.sql;
    }

    public String cursor() {
        return this.cursor;
    }

    public Integer fetchSize() {
        return this.fetchSize;
    }

    public JSONObject getJsonContent() {
        return this.jsonContent;
    }

    private String getFilterObjectAsString(JSONObject jsonContent) {
        String filterVal = jsonContent.getJSONObject("filter").toString();
        return "{\"filter\":" + filterVal + "}";
    }

    private boolean hasFilterInRequest() {
        return this.jsonContent != null && this.jsonContent.has("filter");
    }

    private void addFilterFromJson(BoolQueryBuilder boolQuery) throws SqlParseException {
        try {
            String filter = this.getFilterObjectAsString(this.jsonContent);
            SearchModule searchModule = new SearchModule(Settings.EMPTY, false, Collections.emptyList());
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(new NamedXContentRegistry(searchModule.getNamedXContents()), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);
            parser.nextToken();
            boolQuery.filter((QueryBuilder)BoolQueryBuilder.fromXContent((XContentParser)parser));
        }
        catch (IOException e) {
            throw new SqlParseException("Unable to parse 'filter' in JSON request: " + e.getMessage());
        }
    }

    public BoolQueryBuilder checkAndAddFilter(BoolQueryBuilder boolQuery) throws SqlParseException {
        if (this.hasFilterInRequest()) {
            boolQuery = boolQuery == null ? new BoolQueryBuilder() : boolQuery;
            this.addFilterFromJson(boolQuery);
        }
        return boolQuery;
    }
}

