/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.node.sort;

import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.ExecuteParams;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.PlanNode;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.PhysicalOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.Row;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.estimation.Cost;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.node.BatchPhysicalOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuickSort<T>
extends BatchPhysicalOperator<T> {
    private static final Logger LOG = LogManager.getLogger();
    private final PhysicalOperator<T> next;
    private final String[] orderByColNames;
    private final String orderByType;
    private boolean isDone = false;

    public QuickSort(PhysicalOperator<T> next, List<String> orderByColNames, String orderByType) {
        this.next = next;
        this.orderByColNames = orderByColNames.toArray(new String[0]);
        this.orderByType = orderByType;
    }

    @Override
    public PlanNode[] children() {
        return new PlanNode[]{this.next};
    }

    @Override
    public Cost estimate() {
        return new Cost();
    }

    @Override
    public void open(ExecuteParams params) throws Exception {
        super.open(params);
        this.next.open(params);
    }

    @Override
    protected Collection<Row<T>> prefetch() {
        if (this.isDone) {
            return Collections.emptyList();
        }
        ArrayList<Row<T>> allRowsSorted = new ArrayList<Row<T>>();
        this.next.forEachRemaining(allRowsSorted::add);
        allRowsSorted.sort(this.createRowComparator());
        if (LOG.isTraceEnabled()) {
            LOG.trace("All rows being sorted in RB-Tree: {}", allRowsSorted);
        }
        this.isDone = true;
        return allRowsSorted;
    }

    private Comparator<Row<T>> createRowComparator() {
        Comparator<Row<T>> comparator = Comparator.comparing(o -> o.key(this.orderByColNames));
        if ("DESC".equals(this.orderByType)) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    public String toString() {
        return "QuickSort [ columns=" + Arrays.toString(this.orderByColNames) + ", order=" + this.orderByType + " ]";
    }
}

