/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.node.join;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.ExecuteParams;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Join;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.PhysicalOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.Row;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.estimation.Cost;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.node.join.CombinedRow;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.node.join.JoinAlgorithm;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.resource.blocksize.BlockSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class BlockHashJoin<T>
extends JoinAlgorithm<T> {
    private final boolean isUseTermsFilterOptimization;

    public BlockHashJoin(PhysicalOperator<T> left, PhysicalOperator<T> right, SQLJoinTableSource.JoinType type, Join.JoinCondition condition, BlockSize blockSize, boolean isUseTermsFilterOptimization) {
        super(left, right, type, condition, blockSize);
        this.isUseTermsFilterOptimization = isUseTermsFilterOptimization;
    }

    @Override
    public Cost estimate() {
        return new Cost();
    }

    @Override
    protected void reopenRight() throws Exception {
        Objects.requireNonNull(this.params, "Execute params is not set so unable to add extra filter");
        if (this.isUseTermsFilterOptimization) {
            this.params.add(ExecuteParams.ExecuteParamType.EXTRA_QUERY_FILTER, this.queryForPushedDownOnConds());
        }
        this.right.open(this.params);
    }

    @Override
    protected List<CombinedRow<T>> probe() {
        ArrayList<CombinedRow<T>> combinedRows = new ArrayList<CombinedRow<T>>();
        int totalSize = 0;
        while (this.right.hasNext() && totalSize < this.hashTable.size()) {
            Row rightRow = (Row)this.right.next();
            Collection matchedLeftRows = this.hashTable.match(rightRow);
            if (matchedLeftRows.isEmpty()) continue;
            combinedRows.add(new CombinedRow(rightRow, matchedLeftRows));
            totalSize += matchedLeftRows.size();
        }
        return combinedRows;
    }

    private BoolQueryBuilder queryForPushedDownOnConds() {
        Map<String, Collection<Object>>[] rightNameToLeftValuesGroup;
        BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
        for (Map<String, Collection<Object>> rightNameToLeftValues : rightNameToLeftValuesGroup = this.hashTable.rightFieldWithLeftValues()) {
            if (LOG.isTraceEnabled()) {
                rightNameToLeftValues.forEach((rightName, leftValues) -> LOG.trace("Right name to left values mapping: {} => {}", rightName, leftValues));
            }
            BoolQueryBuilder andQuery = QueryBuilders.boolQuery();
            rightNameToLeftValues.forEach((rightName, leftValues) -> andQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)rightName, (Collection)leftValues)));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Terms filter optimization: {}", (Object)Strings.toString((ToXContent)andQuery));
            }
            orQuery.should((QueryBuilder)andQuery);
        }
        return orQuery;
    }

    public boolean isUseTermsFilterOptimization() {
        return this.isUseTermsFilterOptimization;
    }
}

