/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.estimation;

import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.PlanNode;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.LogicalOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.LogicalPlanVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Group;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.PhysicalOperator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;

public class Estimation<T>
implements LogicalPlanVisitor {
    private Map<LogicalOperator, PhysicalOperator<T>> optimalOps = new IdentityHashMap<LogicalOperator, PhysicalOperator<T>>();
    private PhysicalOperator<T> root;

    @Override
    public boolean visit(Group group) {
        return false;
    }

    @Override
    public void endVisit(PlanNode node) {
        LogicalOperator op = (LogicalOperator)node;
        PhysicalOperator optimal = Arrays.stream(op.toPhysical(this.optimalOps)).min(Comparator.comparing(PhysicalOperator::estimate)).orElseThrow(() -> new IllegalStateException("No optimal operator found: " + op));
        this.optimalOps.put(op, optimal);
        this.root = optimal;
    }

    public PhysicalOperator<T> optimalPlan() {
        return this.root;
    }
}

