/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.rule;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.LogicalPlanVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Group;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Join;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ProjectionPushDown
implements LogicalPlanVisitor {
    private final Project<?> project = new Project(null);

    @Override
    public boolean visit(Project project) {
        this.pushDown(project);
        return true;
    }

    @Override
    public boolean visit(Join join) {
        this.pushDown(join.conditions());
        return true;
    }

    @Override
    public boolean visit(Group group) {
        if (!this.project.isNoOp()) {
            group.pushDown(this.project);
        }
        return false;
    }

    private void pushDown(Project<?> project) {
        project.forEach(this::project);
    }

    private void pushDown(Join.JoinCondition orCond) {
        for (int i = 0; i < orCond.groupSize(); ++i) {
            this.project(orCond.leftTableAlias(), this.columnNamesToFields(orCond.leftColumnNames(i)));
            this.project(orCond.rightTableAlias(), this.columnNamesToFields(orCond.rightColumnNames(i)));
        }
    }

    private void project(String tableAlias, Collection<Field> columns) {
        this.project.project(tableAlias, columns);
    }

    private List<Field> columnNamesToFields(String[] colNames) {
        return Arrays.stream(colNames).map(name -> new Field((String)name, null)).collect(Collectors.toList());
    }
}

