/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.PlanNode;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.LogicalOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.PhysicalOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.node.join.BlockHashJoin;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.resource.blocksize.BlockSize;
import java.util.Map;

public class Join
implements LogicalOperator {
    private final LogicalOperator left;
    private final LogicalOperator right;
    private final SQLJoinTableSource.JoinType type;
    private final JoinCondition condition;
    private final BlockSize blockSize;
    private final boolean isUseTermsFilterOptimization;

    public Join(LogicalOperator left, LogicalOperator right, SQLJoinTableSource.JoinType joinType, JoinCondition condition, BlockSize blockSize, boolean isUseTermsFilterOptimization) {
        this.left = left;
        this.right = right;
        this.type = joinType;
        this.condition = condition;
        this.blockSize = blockSize;
        this.isUseTermsFilterOptimization = isUseTermsFilterOptimization;
    }

    @Override
    public PlanNode[] children() {
        return new PlanNode[]{this.left, this.right};
    }

    @Override
    public <T> PhysicalOperator[] toPhysical(Map<LogicalOperator, PhysicalOperator<T>> optimalOps) {
        PhysicalOperator<T> optimalLeft = optimalOps.get(this.left);
        PhysicalOperator<T> optimalRight = optimalOps.get(this.right);
        return new PhysicalOperator[]{new BlockHashJoin<T>(optimalLeft, optimalRight, this.type, this.condition, this.blockSize, this.isUseTermsFilterOptimization)};
    }

    public JoinCondition conditions() {
        return this.condition;
    }

    public String toString() {
        return "Join [ conditions=" + this.condition + " type=" + this.type + " ]";
    }

    public static class JoinCondition {
        private final String leftTableAlias;
        private final String rightTableAlias;
        private final String[][] leftColumnNames;
        private final String[][] rightColumnNames;

        public JoinCondition(String leftTableAlias, String rightTableAlias, int groupSize) {
            this.leftTableAlias = leftTableAlias;
            this.rightTableAlias = rightTableAlias;
            this.leftColumnNames = new String[groupSize][];
            this.rightColumnNames = new String[groupSize][];
        }

        public void addLeftColumnNames(int groupNum, String[] colNames) {
            this.leftColumnNames[groupNum] = colNames;
        }

        public void addRightColumnNames(int groupNum, String[] colNames) {
            this.rightColumnNames[groupNum] = colNames;
        }

        public int groupSize() {
            return this.leftColumnNames.length;
        }

        public String leftTableAlias() {
            return this.leftTableAlias;
        }

        public String rightTableAlias() {
            return this.rightTableAlias;
        }

        public String[] leftColumnNames(int groupNum) {
            return this.leftColumnNames[groupNum];
        }

        public String[] rightColumnNames(int groupNum) {
            return this.rightColumnNames[groupNum];
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            int groupSize = this.leftColumnNames.length;
            for (int i = 0; i < groupSize; ++i) {
                if (i > 0) {
                    str.append(" OR ");
                }
                str.append("( ");
                int condSize = this.leftColumnNames[i].length;
                for (int j = 0; j < condSize; ++j) {
                    if (j > 0) {
                        str.append(" AND ");
                    }
                    str.append(this.leftTableAlias).append(".").append(this.leftColumnNames[i][j]).append(" = ").append(this.rightTableAlias).append(".").append(this.rightColumnNames[i][j]);
                }
                str.append(" )");
            }
            return str.toString();
        }
    }
}

