/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Order;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.Config;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.Plan;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.PlanNode;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.QueryParams;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.LogicalOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.LogicalPlanVisitor;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Filter;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Group;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Join;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Project;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Sort;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.TableScan;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Top;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.rule.ProjectionPushDown;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.rule.SelectionPushDown;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LogicalPlan
implements Plan {
    private final Config config;
    private final QueryParams params;
    private final LogicalOperator root;
    private final List<LogicalPlanVisitor> rules = Arrays.asList(new SelectionPushDown(), new ProjectionPushDown());

    public LogicalPlan(Config config, QueryParams params) {
        this.config = config;
        this.params = params;
        this.root = this.buildPlanTree();
    }

    @Override
    public void traverse(PlanNode.Visitor visitor) {
        this.root.accept(visitor);
    }

    @Override
    public void optimize() {
        for (LogicalPlanVisitor rule : this.rules) {
            this.root.accept(rule);
        }
    }

    private LogicalOperator buildPlanTree() {
        return this.project(this.top(this.sort(this.filter(this.join(this.top(this.group(this.params.firstRequest(), this.config.scrollPageSize()[0]), this.config.tableLimit1()), this.top(this.group(this.params.secondRequest(), this.config.scrollPageSize()[1]), this.config.tableLimit2())))), this.config.totalLimit()));
    }

    private LogicalOperator project(LogicalOperator next) {
        Project project = new Project(next);
        for (TableInJoinRequestBuilder req : this.getRequests()) {
            if (req.getOriginalSelect().isSelectAll()) {
                project.projectAll(req.getAlias());
                continue;
            }
            project.project(req.getAlias(), req.getReturnedFields());
        }
        return project;
    }

    private LogicalOperator top(LogicalOperator next, int limit) {
        if (limit > 0) {
            return new Top(next, limit);
        }
        return next;
    }

    private LogicalOperator sort(LogicalOperator next) {
        ArrayList<String> orderByColNames = new ArrayList<String>();
        String orderByType = "";
        for (TableInJoinRequestBuilder request : this.getRequests()) {
            List<Order> orderBys = request.getOriginalSelect().getOrderBys();
            if (orderBys == null) continue;
            String tableAlias = request.getAlias() == null ? "" : request.getAlias() + ".";
            for (Order orderBy : orderBys) {
                orderByColNames.add(tableAlias + orderBy.getName());
                orderByType = orderBy.getType();
            }
        }
        if (orderByColNames.isEmpty()) {
            return next;
        }
        return new Sort(next, orderByColNames, orderByType);
    }

    private LogicalOperator filter(LogicalOperator next) {
        Filter filter = new Filter(next, this.getRequests());
        if (filter.isNoOp()) {
            return next;
        }
        return filter;
    }

    private LogicalOperator join(LogicalOperator left, LogicalOperator right) {
        return new Join(left, right, this.params.joinType(), this.groupJoinConditionByOr(), this.config.blockSize(), this.config.isUseTermsFilterOptimization());
    }

    private Join.JoinCondition groupJoinConditionByOr() {
        Join.JoinCondition orCond;
        String leftTableAlias = this.params.firstRequest().getAlias();
        String rightTableAlias = this.params.secondRequest().getAlias();
        if (this.params.joinConditions().isEmpty()) {
            orCond = new Join.JoinCondition(leftTableAlias, rightTableAlias, 0);
        } else {
            orCond = new Join.JoinCondition(leftTableAlias, rightTableAlias, this.params.joinConditions().size());
            for (int i = 0; i < this.params.joinConditions().size(); ++i) {
                List<Map.Entry<Field, Field>> andCond = this.params.joinConditions().get(i);
                String[] leftColumnNames = new String[andCond.size()];
                String[] rightColumnNames = new String[andCond.size()];
                for (int j = 0; j < andCond.size(); ++j) {
                    Map.Entry<Field, Field> cond = andCond.get(j);
                    leftColumnNames[j] = cond.getKey().getName();
                    rightColumnNames[j] = cond.getValue().getName();
                }
                orCond.addLeftColumnNames(i, leftColumnNames);
                orCond.addRightColumnNames(i, rightColumnNames);
            }
        }
        return orCond;
    }

    private LogicalOperator group(TableInJoinRequestBuilder request, int pageSize) {
        return new Group(new TableScan(request, pageSize));
    }

    private List<TableInJoinRequestBuilder> getRequests() {
        return Arrays.asList(this.params.firstRequest(), this.params.secondRequest());
    }

    private <T, U> List<T> map(Collection<U> source, Function<U, T> func) {
        return source.stream().map(func).collect(Collectors.toList());
    }
}

