/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.explain;

import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.explain.ExplanationFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonExplanationFormat
implements ExplanationFormat {
    private final Deque<JSONObject> jsonObjStack = new ArrayDeque<JSONObject>();
    private final int indent;

    public JsonExplanationFormat(int indent) {
        this.indent = indent;
    }

    @Override
    public void prepare(Map<String, String> kvs) {
        this.jsonObjStack.push(new JSONObject(kvs));
    }

    @Override
    public void start(String name) {
        JSONObject json = new JSONObject();
        this.jsonObjStack.peek().put(name, (Object)json);
        this.jsonObjStack.push(json);
    }

    @Override
    public void explain(Object obj) {
        JSONObject json = new JSONObject(obj);
        this.jsonifyValueIfValidJson(json);
        this.appendToArrayIfExist(this.nodeName(obj), json);
        this.jsonObjStack.push(json);
    }

    @Override
    public void end() {
        this.jsonObjStack.pop();
    }

    public String toString() {
        return this.jsonObjStack.pop().toString(this.indent);
    }

    private void jsonifyValueIfValidJson(JSONObject json) {
        for (String key : json.keySet()) {
            try {
                JSONObject jsonValue = new JSONObject(json.getString(key));
                json.put(key, (Object)jsonValue);
            }
            catch (JSONException jSONException) {}
        }
    }

    private String nodeName(Object obj) {
        return obj.toString();
    }

    private void appendToArrayIfExist(String name, JSONObject child) {
        JSONObject parent = this.jsonObjStack.peek();
        Object otherChild = parent.opt(name);
        if (otherChild == null) {
            parent.put(name, (Object)child);
        } else {
            if (!(otherChild instanceof JSONArray)) {
                parent.remove(name);
                parent.append(name, otherChild);
            }
            parent.append(name, (Object)child);
        }
    }
}

