/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.explain;

import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.Plan;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.PlanNode;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.explain.ExplanationFormat;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.LogicalOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.logical.node.Group;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.PhysicalOperator;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class Explanation
implements PlanNode.Visitor {
    private static final String DESCRIPTION = "Hash Join algorithm builds hash table based on result of first query, and then probes hash table to find matched rows for each row returned by second query";
    private final Plan logicalPlan;
    private final Plan physicalPlan;
    private final ExplanationFormat format;

    public Explanation(Plan logicalPlan, Plan physicalPlan, ExplanationFormat format) {
        this.logicalPlan = logicalPlan;
        this.physicalPlan = physicalPlan;
        this.format = format;
    }

    public String toString() {
        this.format.prepare((Map<String, String>)ImmutableMap.of((Object)"description", (Object)DESCRIPTION));
        this.format.start("Logical Plan");
        this.logicalPlan.traverse(this);
        this.format.end();
        this.format.start("Physical Plan");
        this.physicalPlan.traverse(this);
        this.format.end();
        return this.format.toString();
    }

    @Override
    public boolean visit(PlanNode node) {
        if (this.isValidOp(node)) {
            this.format.explain(node);
        }
        return true;
    }

    @Override
    public void endVisit(PlanNode node) {
        if (this.isValidOp(node)) {
            this.format.end();
        }
    }

    private boolean isValidOp(PlanNode node) {
        return this.isValidLogical(node) || this.isPhysical(node);
    }

    private boolean isValidLogical(PlanNode node) {
        return node instanceof LogicalOperator && (node instanceof Group || !((LogicalOperator)node).isNoOp());
    }

    private boolean isPhysical(PlanNode node) {
        return node instanceof PhysicalOperator;
    }
}

