/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core;

import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.resource.blocksize.AdaptiveBlockSize;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.resource.blocksize.BlockSize;

public class Config {
    public static final int DEFAULT_BLOCK_SIZE = 10000;
    public static final int DEFAULT_SCROLL_PAGE_SIZE = 10000;
    public static final int DEFAULT_CIRCUIT_BREAK_LIMIT = 85;
    public static final double[] DEFAULT_BACK_OFF_RETRY_INTERVALS = new double[]{4.0, 12.0, 20.0};
    public static final int DEFAULT_TIME_OUT = 60;
    private BlockSize blockSize = new BlockSize.FixedBlockSize(10000);
    private Integer[] scrollPageSizes = new Integer[]{10000, 10000};
    private Integer circuitBreakLimit = 85;
    private double[] backOffRetryIntervals = DEFAULT_BACK_OFF_RETRY_INTERVALS;
    private int totalLimit;
    private int tableLimit1;
    private int tableLimit2;
    private boolean isUseTermsFilterOptimization = false;
    private int timeout = 60;

    public BlockSize blockSize() {
        return this.blockSize;
    }

    public void configureBlockSize(Object[] params) {
        if (params.length > 0) {
            Integer size = (Integer)params[0];
            this.blockSize = size > 0 ? new BlockSize.FixedBlockSize(size) : new AdaptiveBlockSize(0);
        }
    }

    public Integer[] scrollPageSize() {
        return this.scrollPageSizes;
    }

    public void configureScrollPageSize(Object[] params) {
        if (params.length == 1) {
            this.scrollPageSizes = new Integer[]{(Integer)params[0], (Integer)params[0]};
        } else if (params.length >= 2) {
            this.scrollPageSizes = (Integer[])params;
        }
    }

    public int circuitBreakLimit() {
        return this.circuitBreakLimit;
    }

    public void configureCircuitBreakLimit(Object[] params) {
        if (params.length > 0) {
            this.circuitBreakLimit = (Integer)params[0];
        }
    }

    public double[] backOffRetryIntervals() {
        return this.backOffRetryIntervals;
    }

    public void configureBackOffRetryIntervals(Object[] params) {
        this.backOffRetryIntervals = new double[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.backOffRetryIntervals[i] = ((Integer)params[i]).intValue();
        }
    }

    public void configureLimit(Integer totalLimit, Integer tableLimit1, Integer tableLimit2) {
        if (totalLimit != null) {
            this.totalLimit = totalLimit;
        }
        if (tableLimit1 != null) {
            this.tableLimit1 = tableLimit1;
        }
        if (tableLimit2 != null) {
            this.tableLimit2 = tableLimit2;
        }
    }

    public int totalLimit() {
        return this.totalLimit;
    }

    public int tableLimit1() {
        return this.tableLimit1;
    }

    public int tableLimit2() {
        return this.tableLimit2;
    }

    public void configureTermsFilterOptimization(boolean isUseTermFiltersOptimization) {
        this.isUseTermsFilterOptimization = isUseTermFiltersOptimization;
    }

    public boolean isUseTermsFilterOptimization() {
        return this.isUseTermsFilterOptimization;
    }

    public void configureTimeOut(Object[] params) {
        if (params.length > 0) {
            this.timeout = (Integer)params[0];
        }
    }

    public int timeout() {
        return this.timeout;
    }
}

