/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.converter;

import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.ColumnTypeProvider;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Select;
import com.amazon.opendistroforelasticsearch.sql.legacy.expression.domain.BindingTuple;
import com.amazon.opendistroforelasticsearch.sql.legacy.parser.SqlParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.AggregationQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.converter.SQLAggregationParser;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.core.ColumnNode;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.PhysicalOperator;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.node.project.PhysicalProject;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.planner.physical.node.scroll.PhysicalScroll;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;

public class SQLToOperatorConverter
extends MySqlASTVisitorAdapter {
    private static final Logger LOG = LogManager.getLogger(SQLToOperatorConverter.class);
    private final Client client;
    private final SQLAggregationParser aggregationParser;
    private PhysicalOperator<BindingTuple> physicalOperator;

    public SQLToOperatorConverter(Client client, ColumnTypeProvider columnTypeProvider) {
        this.client = client;
        this.aggregationParser = new SQLAggregationParser(columnTypeProvider);
    }

    public boolean visit(MySqlSelectQueryBlock query) {
        this.aggregationParser.parse(query);
        this.physicalOperator = this.project(this.scroll(query));
        return false;
    }

    public List<ColumnNode> getColumnNodes() {
        return this.aggregationParser.getColumnNodes();
    }

    private PhysicalOperator<BindingTuple> project(PhysicalOperator<BindingTuple> input) {
        return new PhysicalProject(input, this.aggregationParser.getColumnNodes());
    }

    private PhysicalOperator<BindingTuple> scroll(MySqlSelectQueryBlock query) {
        query.getSelectList().clear();
        query.getSelectList().addAll(this.aggregationParser.selectItemList());
        Select select = new SqlParser().parseSelect(query);
        return new PhysicalScroll(new AggregationQueryAction(this.client, select));
    }

    public PhysicalOperator<BindingTuple> getPhysicalOperator() {
        return this.physicalOperator;
    }
}

