/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.multi;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Field;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Select;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.DefaultQueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.QueryAction;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.SqlElasticRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.multi.MultiQueryRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.multi.MultiQuerySelect;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.Client;

public class MultiQueryAction
extends QueryAction {
    private MultiQuerySelect multiQuerySelect;

    public MultiQueryAction(Client client, MultiQuerySelect multiSelect) {
        super(client, null);
        this.multiQuerySelect = multiSelect;
    }

    @Override
    public SqlElasticRequestBuilder explain() throws SqlParseException {
        if (!this.isValidMultiSelectReturnFields()) {
            throw new SqlParseException("on multi query fields/aliases of one table should be subset of other");
        }
        MultiQueryRequestBuilder requestBuilder = new MultiQueryRequestBuilder(this.multiQuerySelect);
        requestBuilder.setFirstSearchRequest(this.createRequestBuilder(this.multiQuerySelect.getFirstSelect()));
        requestBuilder.setSecondSearchRequest(this.createRequestBuilder(this.multiQuerySelect.getSecondSelect()));
        requestBuilder.fillTableAliases(this.multiQuerySelect.getFirstSelect().getFields(), this.multiQuerySelect.getSecondSelect().getFields());
        return requestBuilder;
    }

    private boolean isValidMultiSelectReturnFields() {
        List<Field> firstQueryFields = this.multiQuerySelect.getFirstSelect().getFields();
        List<Field> secondQueryFields = this.multiQuerySelect.getSecondSelect().getFields();
        if (firstQueryFields.size() > secondQueryFields.size()) {
            return this.isSubsetFields(firstQueryFields, secondQueryFields);
        }
        return this.isSubsetFields(secondQueryFields, firstQueryFields);
    }

    private boolean isSubsetFields(List<Field> bigGroup, List<Field> smallerGroup) {
        String fieldName;
        HashSet<String> biggerGroup = new HashSet<String>();
        for (Field field : bigGroup) {
            fieldName = this.getNameOrAlias(field);
            biggerGroup.add(fieldName);
        }
        for (Field field : smallerGroup) {
            fieldName = this.getNameOrAlias(field);
            if (biggerGroup.contains(fieldName)) continue;
            return false;
        }
        return true;
    }

    private String getNameOrAlias(Field field) {
        String fieldName = field.getName();
        if (field.getAlias() != null && !field.getAlias().isEmpty()) {
            fieldName = field.getAlias();
        }
        return fieldName;
    }

    protected SearchRequestBuilder createRequestBuilder(Select select) throws SqlParseException {
        DefaultQueryAction queryAction = new DefaultQueryAction(this.client, select);
        queryAction.explain();
        return queryAction.getRequestBuilder();
    }
}

