/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.join;

import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Condition;
import com.amazon.opendistroforelasticsearch.sql.legacy.domain.Where;
import com.amazon.opendistroforelasticsearch.sql.legacy.exception.SqlParseException;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.JoinRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.maker.QueryMaker;
import java.io.IOException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.json.JSONObject;
import org.json.JSONStringer;

public class NestedLoopsElasticRequestBuilder
extends JoinRequestBuilder {
    private Where connectedWhere;
    private int multiSearchMaxSize = 100;

    @Override
    public String explain() {
        String conditions = "";
        try {
            Where where = (Where)this.connectedWhere.clone();
            this.setValueTypeConditionToStringRecursive(where);
            if (where != null) {
                conditions = QueryMaker.explain(where, false).toString();
            }
        }
        catch (SqlParseException | CloneNotSupportedException e) {
            conditions = "Could not parse conditions due to " + e.getMessage();
        }
        String desc = "Nested Loops run first query, and for each result run second query with additional conditions as following.";
        String[] queries = this.explainNL();
        JSONStringer jsonStringer = new JSONStringer();
        jsonStringer.object().key("description").value((Object)desc).key("conditions").value((Object)new JSONObject(conditions)).key("first query").value((Object)new JSONObject(queries[0])).key("second query").value((Object)new JSONObject(queries[1])).endObject();
        return jsonStringer.toString();
    }

    public int getMultiSearchMaxSize() {
        return this.multiSearchMaxSize;
    }

    public void setMultiSearchMaxSize(int multiSearchMaxSize) {
        this.multiSearchMaxSize = multiSearchMaxSize;
    }

    public Where getConnectedWhere() {
        return this.connectedWhere;
    }

    public void setConnectedWhere(Where connectedWhere) {
        this.connectedWhere = connectedWhere;
    }

    private void setValueTypeConditionToStringRecursive(Where where) {
        if (where == null) {
            return;
        }
        if (where instanceof Condition) {
            Condition c = (Condition)where;
            c.setValue(c.getValue().toString());
            return;
        }
        for (Where innerWhere : where.getWheres()) {
            this.setValueTypeConditionToStringRecursive(innerWhere);
        }
    }

    private String[] explainNL() {
        return new String[]{this.explainQuery(this.getFirstTable()), this.explainQuery(this.getSecondTable())};
    }

    private String explainQuery(TableInJoinRequestBuilder requestBuilder) {
        try {
            XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).prettyPrint();
            ((SearchRequest)requestBuilder.getRequestBuilder().request()).source().toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            return BytesReference.bytes((XContentBuilder)xContentBuilder).utf8ToString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

