/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.opendistroforelasticsearch.sql.legacy.query.join;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.SqlElasticRequestBuilder;
import com.amazon.opendistroforelasticsearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class JoinRequestBuilder
implements SqlElasticRequestBuilder {
    private MultiSearchRequest multi;
    private TableInJoinRequestBuilder firstTable = new TableInJoinRequestBuilder();
    private TableInJoinRequestBuilder secondTable = new TableInJoinRequestBuilder();
    private SQLJoinTableSource.JoinType joinType;
    private int totalLimit;

    @Override
    public ActionRequest request() {
        if (this.multi == null) {
            this.buildMulti();
        }
        return this.multi;
    }

    private void buildMulti() {
        this.multi = new MultiSearchRequest();
        this.multi.add(this.firstTable.getRequestBuilder());
        this.multi.add(this.secondTable.getRequestBuilder());
    }

    @Override
    public String explain() {
        try {
            XContentBuilder firstBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).prettyPrint();
            ((SearchRequest)this.firstTable.getRequestBuilder().request()).source().toXContent(firstBuilder, ToXContent.EMPTY_PARAMS);
            XContentBuilder secondBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).prettyPrint();
            ((SearchRequest)this.secondTable.getRequestBuilder().request()).source().toXContent(secondBuilder, ToXContent.EMPTY_PARAMS);
            return String.format(" first query:\n%s\n second query:\n%s", BytesReference.bytes((XContentBuilder)firstBuilder).utf8ToString(), BytesReference.bytes((XContentBuilder)secondBuilder).utf8ToString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ActionResponse get() {
        return null;
    }

    @Override
    public ActionRequestBuilder getBuilder() {
        return this.firstTable.getRequestBuilder();
    }

    public MultiSearchRequest getMulti() {
        return this.multi;
    }

    public void setMulti(MultiSearchRequest multi) {
        this.multi = multi;
    }

    public SQLJoinTableSource.JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(SQLJoinTableSource.JoinType joinType) {
        this.joinType = joinType;
    }

    public TableInJoinRequestBuilder getFirstTable() {
        return this.firstTable;
    }

    public TableInJoinRequestBuilder getSecondTable() {
        return this.secondTable;
    }

    public int getTotalLimit() {
        return this.totalLimit;
    }

    public void setTotalLimit(int totalLimit) {
        this.totalLimit = totalLimit;
    }
}

